/*
 * Decompiled with CFR 0.152.
 */
package net.armory_rpgs.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.armory_rpgs.item.Group;
import net.armory_rpgs.spell.ArmorySounds;
import net.armory_rpgs.spell.SetBonuses;
import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.spell_engine.api.config.ArmorSetConfig;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.entity.SpellEngineAttributes;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.api.item.armor.Armor;
import net.spell_engine.api.spell.SpellDataComponents;
import net.spell_power.api.SpellPowerMechanics;
import net.spell_power.api.SpellSchools;

public class ArmorSets {
    public static final ArrayList<Armor.Entry> entries = new ArrayList();
    private static final ResourceLocation ATTACK_DAMAGE_ID = ResourceLocation.withDefaultNamespace((String)"generic.attack_damage");
    private static final ResourceLocation ATTACK_SPEED_ID = ResourceLocation.withDefaultNamespace((String)"generic.attack_speed");
    private static final ResourceLocation KNOCKBACK_ID = ResourceLocation.withDefaultNamespace((String)"generic.knockback_resistance");
    private static final ResourceLocation MOVEMENT_SPEED_ID = ResourceLocation.withDefaultNamespace((String)"generic.movement_speed");
    private static final ResourceLocation ARMOR_TOUGHNESS_ID = ResourceLocation.withDefaultNamespace((String)"generic.armor_toughness");
    private static final String CRIT_MOD_ID = "critical_strike";
    private static final ResourceLocation CRIT_CHANCE_ID = ResourceLocation.fromNamespaceAndPath((String)"critical_strike", (String)"chance");
    private static final ResourceLocation CRIT_DAMAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"critical_strike", (String)"damage");
    public static final int enchantability = 18;
    public static Holder<ArmorMaterial> wizard_robe = ArmorSets.material("wizard_robe", 1, 3, 2, 1, 18, (Holder<SoundEvent>)ArmorySounds.cloth_equip.entry(), () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}));
    public static Holder<ArmorMaterial> priest_robe = ArmorSets.material("priest_robe", 1, 3, 2, 1, 18, (Holder<SoundEvent>)ArmorySounds.cloth_equip.entry(), () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}));
    public static Holder<ArmorMaterial> archer_armor = ArmorSets.material("archer_armor", 2, 4, 4, 2, 18, (Holder<SoundEvent>)ArmorySounds.leather_equip.entry(), () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}));
    public static Holder<ArmorMaterial> rogue_armor = ArmorSets.material("rogue_armor", 2, 4, 4, 2, 18, (Holder<SoundEvent>)ArmorySounds.leather_equip.entry(), () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}));
    public static Holder<ArmorMaterial> paladin_armor = ArmorSets.material("paladin_armor", 3, 8, 6, 3, 18, (Holder<SoundEvent>)ArmorySounds.plate_equip.entry(), () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}));
    public static Holder<ArmorMaterial> warrior_armor = ArmorSets.material("warrior_armor", 3, 8, 6, 2, 18, (Holder<SoundEvent>)ArmorySounds.plate_equip.entry(), () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}));
    private static final float plate_toughness = 1.0f;
    private static final float caster_spell_power = 0.35f;
    private static final float priest_haste = 0.05f;
    private static final float paladin_spell_power = 1.5f;
    public static final float rogue_evasion = 0.05f;
    public static final float rogue_haste = 0.05f;
    public static final float rogue_damage = 0.06f;
    public static final float rogue_crit_chance = 0.03f;
    public static final float warrior_damage = 0.06f;
    public static final float warrior_knockback = 0.1f;
    public static final float warrior_crit_damage = 0.06f;
    public static final float arrow_haste = 0.05f;
    public static final float arrow_damage = 0.12f;
    private static final float crit_damage_t3 = 0.08f;
    private static final float crit_chance_t3 = 0.03f;
    private static final float haste_t3 = 0.03f;
    public static final int durability = 40;
    public static final Armor.Entry astral = ArmorSets.create(wizard_robe, ResourceLocation.fromNamespaceAndPath((String)"armory_rpgs", (String)"astral_robe"), 40, 5, Armor.CustomItem::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).add(AttributeModifier.multiply((ResourceLocation)SpellSchools.ARCANE.id, (float)0.35f)).add(AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.HASTE.id, (float)0.03f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).add(AttributeModifier.multiply((ResourceLocation)SpellSchools.ARCANE.id, (float)0.35f)).add(AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.HASTE.id, (float)0.03f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).add(AttributeModifier.multiply((ResourceLocation)SpellSchools.ARCANE.id, (float)0.35f)).add(AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.HASTE.id, (float)0.03f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).add(AttributeModifier.multiply((ResourceLocation)SpellSchools.ARCANE.id, (float)0.35f)).add(AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.HASTE.id, (float)0.03f))), ArmorSets.commonSettings(SetBonuses.astral.id())).translatedName("Astral Hat", "Astral Robe", "Astral Breeches", "Astral Boots");
    public static final Armor.Entry scarlet = ArmorSets.create(wizard_robe, ResourceLocation.fromNamespaceAndPath((String)"armory_rpgs", (String)"scarlet_robe"), 40, 5, Armor.CustomItem::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).add(AttributeModifier.multiply((ResourceLocation)SpellSchools.FIRE.id, (float)0.35f)).add(AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.CRITICAL_CHANCE.id, (float)0.03f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).add(AttributeModifier.multiply((ResourceLocation)SpellSchools.FIRE.id, (float)0.35f)).add(AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.CRITICAL_CHANCE.id, (float)0.03f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).add(AttributeModifier.multiply((ResourceLocation)SpellSchools.FIRE.id, (float)0.35f)).add(AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.CRITICAL_CHANCE.id, (float)0.03f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).add(AttributeModifier.multiply((ResourceLocation)SpellSchools.FIRE.id, (float)0.35f)).add(AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.CRITICAL_CHANCE.id, (float)0.03f))), ArmorSets.commonSettings(SetBonuses.scarlet.id())).translatedName("Scarlet Hat", "Scarlet Robe", "Scarlet Breeches", "Scarlet Boots");
    public static final Armor.Entry glacier = ArmorSets.create(wizard_robe, ResourceLocation.fromNamespaceAndPath((String)"armory_rpgs", (String)"glacier_robe"), 40, 5, Armor.CustomItem::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).add(AttributeModifier.multiply((ResourceLocation)SpellSchools.FROST.id, (float)0.35f)).add(AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.CRITICAL_DAMAGE.id, (float)0.08f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).add(AttributeModifier.multiply((ResourceLocation)SpellSchools.FROST.id, (float)0.35f)).add(AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.CRITICAL_DAMAGE.id, (float)0.08f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).add(AttributeModifier.multiply((ResourceLocation)SpellSchools.FROST.id, (float)0.35f)).add(AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.CRITICAL_DAMAGE.id, (float)0.08f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).add(AttributeModifier.multiply((ResourceLocation)SpellSchools.FROST.id, (float)0.35f)).add(AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.CRITICAL_DAMAGE.id, (float)0.08f))), ArmorSets.commonSettings(SetBonuses.glacier.id())).translatedName("Glacier Hat", "Glacier Robe", "Glacier Breeches", "Glacier Boots");
    public static final Armor.Entry avatar = ArmorSets.create(priest_robe, ResourceLocation.fromNamespaceAndPath((String)"armory_rpgs", (String)"avatar_robe"), 40, 5, Armor.CustomItem::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.HEALING.id, (float)0.35f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.HASTE.id, (float)0.05f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.HEALING.id, (float)0.35f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.HASTE.id, (float)0.05f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.HEALING.id, (float)0.35f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.HASTE.id, (float)0.05f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.HEALING.id, (float)0.35f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.HASTE.id, (float)0.05f)))), ArmorSets.commonSettings(SetBonuses.avatar.id())).translatedName("Avatar Cowl", "Avatar Vestment", "Avatar Breeches", "Avatar Boots");
    public static final Armor.Entry justicar = ArmorSets.create(paladin_armor, ResourceLocation.fromNamespaceAndPath((String)"armory_rpgs", (String)"justicar_armor"), 40, 5, Armor.CustomItem::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).add(ArmorSets.toughnessBonus(1.0f)).addAll((List)AttributeModifier.bonuses(List.of(SpellSchools.HEALING.id), (float)1.5f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(8).add(ArmorSets.toughnessBonus(1.0f)).addAll((List)AttributeModifier.bonuses(List.of(SpellSchools.HEALING.id), (float)1.5f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(6).add(ArmorSets.toughnessBonus(1.0f)).addAll((List)AttributeModifier.bonuses(List.of(SpellSchools.HEALING.id), (float)1.5f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).add(ArmorSets.toughnessBonus(1.0f)).addAll((List)AttributeModifier.bonuses(List.of(SpellSchools.HEALING.id), (float)1.5f))), ArmorSets.commonSettings(SetBonuses.justicar.id())).translatedName("Justicar Faceguard", "Justicar Chestplate", "Justicar Legguards", "Justicar Boots");
    public static final Armor.Entry destroyer = ArmorSets.create(warrior_armor, ResourceLocation.fromNamespaceAndPath((String)"armory_rpgs", (String)"destroyer_armor"), 40, 5, Armor.CustomItem::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).add(ArmorSets.damageMultiplier(0.06f)).add(ArmorSets.toughnessBonus(1.0f)).add(ArmorSets.knockbackBonus(0.1f)).addConditional("critical_strike", List.of(ArmorSets.damageMultiplier(0.06f), ArmorSets.toughnessBonus(1.0f), ArmorSets.critDamage(0.06f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(8).add(ArmorSets.damageMultiplier(0.06f)).add(ArmorSets.toughnessBonus(1.0f)).add(ArmorSets.knockbackBonus(0.1f)).addConditional("critical_strike", List.of(ArmorSets.damageMultiplier(0.06f), ArmorSets.toughnessBonus(1.0f), ArmorSets.critDamage(0.06f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(6).add(ArmorSets.damageMultiplier(0.06f)).add(ArmorSets.toughnessBonus(1.0f)).add(ArmorSets.knockbackBonus(0.1f)).addConditional("critical_strike", List.of(ArmorSets.damageMultiplier(0.06f), ArmorSets.toughnessBonus(1.0f), ArmorSets.critDamage(0.06f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).add(ArmorSets.damageMultiplier(0.06f)).add(ArmorSets.toughnessBonus(1.0f)).add(ArmorSets.knockbackBonus(0.1f)).addConditional("critical_strike", List.of(ArmorSets.damageMultiplier(0.06f), ArmorSets.toughnessBonus(1.0f), ArmorSets.critDamage(0.06f)))), ArmorSets.commonSettings(SetBonuses.destroyer.id())).translatedName("Destroyer Greathelm", "Destroyer Chestplate", "Destroyer Greaves", "Destroyer Boots");
    public static final Armor.Entry deathmantle = ArmorSets.create(rogue_armor, ResourceLocation.fromNamespaceAndPath((String)"armory_rpgs", (String)"deathmantle_armor"), 40, 5, Armor.CustomItem::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).add(ArmorSets.evasionBonus(0.05f)).add(ArmorSets.hasteMultiplier(0.05f)).add(ArmorSets.damageMultiplier(0.06f)).addConditional("critical_strike", List.of(ArmorSets.evasionBonus(0.05f), ArmorSets.hasteMultiplier(0.05f), ArmorSets.critChance(0.03f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(4).add(ArmorSets.evasionBonus(0.05f)).add(ArmorSets.hasteMultiplier(0.05f)).add(ArmorSets.damageMultiplier(0.06f)).addConditional("critical_strike", List.of(ArmorSets.evasionBonus(0.05f), ArmorSets.hasteMultiplier(0.05f), ArmorSets.critChance(0.03f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(4).add(ArmorSets.evasionBonus(0.05f)).add(ArmorSets.hasteMultiplier(0.05f)).add(ArmorSets.damageMultiplier(0.06f)).addConditional("critical_strike", List.of(ArmorSets.evasionBonus(0.05f), ArmorSets.hasteMultiplier(0.05f), ArmorSets.critChance(0.03f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).add(ArmorSets.evasionBonus(0.05f)).add(ArmorSets.hasteMultiplier(0.05f)).add(ArmorSets.damageMultiplier(0.06f)).addConditional("critical_strike", List.of(ArmorSets.evasionBonus(0.05f), ArmorSets.hasteMultiplier(0.05f), ArmorSets.critChance(0.03f)))), ArmorSets.commonSettings(SetBonuses.deathmantle.id())).translatedName("Deathmantle Hood", "Deathmantle Tunic", "Deathmantle Leggings", "Deathmantle Boots");
    public static final Armor.Entry strider = ArmorSets.create(archer_armor, ResourceLocation.fromNamespaceAndPath((String)"armory_rpgs", (String)"strider_armor"), 40, 5, Armor.CustomItem::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).add(ArmorSets.rangedDamageMultiplier(0.12f)).add(ArmorSets.rangedHasteMultiplier(0.05f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(4).add(ArmorSets.rangedDamageMultiplier(0.12f)).add(ArmorSets.rangedHasteMultiplier(0.05f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(4).add(ArmorSets.rangedDamageMultiplier(0.12f)).add(ArmorSets.rangedHasteMultiplier(0.05f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).add(ArmorSets.rangedDamageMultiplier(0.12f)).add(ArmorSets.rangedHasteMultiplier(0.05f))), ArmorSets.commonSettings(SetBonuses.strider.id())).translatedName("Strider Hood", "Strider Tunic", "Strider Leggings", "Strider Boots");

    private static Armor.Entry create(Holder<ArmorMaterial> material, ResourceLocation id, int durability, int tier, Armor.Set.ItemFactory factory, ArmorSetConfig defaults, Armor.ItemSettingsTweaker settings) {
        Armor.Entry entry = Armor.Entry.create(material, (ResourceLocation)id, (int)durability, (Armor.Set.ItemFactory)factory, (ArmorSetConfig)defaults, (Equipment.LootProperties)Equipment.LootProperties.of((int)tier), (Armor.ItemSettingsTweaker)settings);
        entries.add(entry);
        return entry;
    }

    public static Holder<ArmorMaterial> material(String name, int protectionHead, int protectionChest, int protectionLegs, int protectionFeet, int enchantability, Holder<SoundEvent> equipSound, Supplier<Ingredient> repairIngredient) {
        ArmorMaterial material = new ArmorMaterial(Map.of(ArmorItem.Type.HELMET, protectionHead, ArmorItem.Type.CHESTPLATE, protectionChest, ArmorItem.Type.LEGGINGS, protectionLegs, ArmorItem.Type.BOOTS, protectionFeet), enchantability, equipSound, repairIngredient, List.of(new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)"armory_rpgs", (String)name))), 0.0f, 0.0f);
        return Registry.registerForHolder((Registry)BuiltInRegistries.ARMOR_MATERIAL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"armory_rpgs", (String)name), (Object)material);
    }

    private static AttributeModifier damageMultiplier(float value) {
        return new AttributeModifier(ATTACK_DAMAGE_ID.toString(), value, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }

    private static AttributeModifier hasteMultiplier(float value) {
        return new AttributeModifier(ATTACK_SPEED_ID.toString(), value, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }

    private static AttributeModifier knockbackBonus(float value) {
        return new AttributeModifier(KNOCKBACK_ID.toString(), value, AttributeModifier.Operation.ADD_VALUE);
    }

    private static AttributeModifier movementSpeed(float value) {
        return new AttributeModifier(MOVEMENT_SPEED_ID.toString(), value, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }

    private static AttributeModifier evasionBonus(float value) {
        return new AttributeModifier(SpellEngineAttributes.EVASION_CHANCE.id.toString(), value, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }

    private static AttributeModifier toughnessBonus(float value) {
        return new AttributeModifier(ARMOR_TOUGHNESS_ID.toString(), value, AttributeModifier.Operation.ADD_VALUE);
    }

    private static AttributeModifier rangedDamageMultiplier(float value) {
        return new AttributeModifier(EntityAttributes_RangedWeapon.DAMAGE.id, value, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }

    private static AttributeModifier rangedHasteMultiplier(float value) {
        return new AttributeModifier(EntityAttributes_RangedWeapon.HASTE.id, value, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }

    private static AttributeModifier critChance(float value) {
        return new AttributeModifier(CRIT_CHANCE_ID.toString(), value, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }

    private static AttributeModifier critDamage(float value) {
        return new AttributeModifier(CRIT_DAMAGE_ID.toString(), value, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }

    private static Armor.ItemSettingsTweaker commonSettings(ResourceLocation equipmentSetId) {
        return Armor.ItemSettingsTweaker.standard(itemSettings -> itemSettings.component(SpellDataComponents.EQUIPMENT_SET, (Object)equipmentSetId).component(DataComponents.RARITY, (Object)Rarity.RARE));
    }

    public static void register(Map<String, ArmorSetConfig> configs) {
        Armor.register(configs, entries, Group.KEY);
    }
}

