/*
 * Decompiled with CFR 0.152.
 */
package net.armory_rpgs.item;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.List;
import net.armory_rpgs.item.FightClass;
import net.armory_rpgs.item.Group;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.level.ItemLike;

public class SmithingTemplates {
    private static final ChatFormatting TITLE_FORMATTING = ChatFormatting.GRAY;
    private static final ChatFormatting DESCRIPTION_FORMATTING = ChatFormatting.BLUE;
    private static final ResourceLocation EMPTY_ARMOR_SLOT_HELMET_TEXTURE = ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_helmet");
    private static final ResourceLocation EMPTY_ARMOR_SLOT_CHESTPLATE_TEXTURE = ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_chestplate");
    private static final ResourceLocation EMPTY_ARMOR_SLOT_LEGGINGS_TEXTURE = ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_leggings");
    private static final ResourceLocation EMPTY_ARMOR_SLOT_BOOTS_TEXTURE = ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_boots");
    public static final ArrayList<Entry> ENTRIES = new ArrayList();
    public static final Entry EPIC_UPGRADE = SmithingTemplates.add(Entry.of("epic_armor", List.of(FightClass.ARCANE_WIZARD, FightClass.FIRE_WIZARD, FightClass.FROST_WIZARD, FightClass.ARCHER), new Translations("Smithing Template", "Superior Armor Upgrade", "Specialized Armor", "Upgrade Crystal", "Add a piece of armor", "Add upgrade crystal")));

    public static Entry add(Entry entry) {
        ENTRIES.add(entry);
        return entry;
    }

    public static void register() {
        for (Entry entry : ENTRIES) {
            Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)entry.id(), (Object)entry.item().get());
        }
        ItemGroupEvents.modifyEntriesEvent(Group.KEY).register(content -> {
            for (Entry entry : ENTRIES) {
                content.accept((ItemLike)entry.item().get());
            }
        });
    }

    public record Entry(String name, List<FightClass> classes, Translations translations, java.util.function.Supplier<SmithingTemplateItem> item) {
        public static Entry of(String name, List<FightClass> classes, Translations translations) {
            Entry entry = new Entry(name, classes, translations, null);
            Supplier factory = Suppliers.memoize(() -> new SmithingTemplateItem(entry.appliesToText(), entry.ingredientsText(), entry.upgradeText(), entry.baseSlotDescriptionText(), entry.additionsSlotDescriptionText(), Entry.baseSlotTextures(), Entry.additionsTextures(), new FeatureFlag[0]));
            return new Entry(name, classes, translations, (java.util.function.Supplier<SmithingTemplateItem>)factory);
        }

        public ResourceLocation id() {
            return ResourceLocation.fromNamespaceAndPath((String)"armory_rpgs", (String)(this.name + "_upgrade"));
        }

        public String upgradeTranslationKey() {
            return Util.makeDescriptionId((String)"upgrade", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"armory_rpgs", (String)(this.name + "_upgrade")));
        }

        public Component upgradeText() {
            return Component.translatable((String)this.upgradeTranslationKey()).withStyle(TITLE_FORMATTING);
        }

        public String appliesToTranslationKey() {
            return Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"armory_rpgs", (String)("smithing_template." + this.name + "_upgrade.applies_to")));
        }

        public Component appliesToText() {
            return Component.translatable((String)this.appliesToTranslationKey()).withStyle(DESCRIPTION_FORMATTING);
        }

        public String ingredientsTranslationKey() {
            return Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"armory_rpgs", (String)("smithing_template." + this.name + "_upgrade.ingredients")));
        }

        public Component ingredientsText() {
            String key = this.ingredientsTranslationKey();
            return Component.translatable((String)key).withStyle(DESCRIPTION_FORMATTING);
        }

        public String baseSlotDescriptionTranslationKey() {
            return Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"armory_rpgs", (String)("smithing_template." + this.name + "_upgrade.base_slot_description")));
        }

        public Component baseSlotDescriptionText() {
            return Component.translatable((String)this.baseSlotDescriptionTranslationKey());
        }

        public String additionsSlotDescriptionTranslationKey() {
            return Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"armory_rpgs", (String)("smithing_template." + this.name + "_upgrade.additions_slot_description")));
        }

        public Component additionsSlotDescriptionText() {
            return Component.translatable((String)this.additionsSlotDescriptionTranslationKey());
        }

        private static List<ResourceLocation> baseSlotTextures() {
            return List.of(EMPTY_ARMOR_SLOT_HELMET_TEXTURE, EMPTY_ARMOR_SLOT_CHESTPLATE_TEXTURE, EMPTY_ARMOR_SLOT_LEGGINGS_TEXTURE, EMPTY_ARMOR_SLOT_BOOTS_TEXTURE);
        }

        private static List<ResourceLocation> additionsTextures() {
            return List.of();
        }
    }

    public record Translations(String itemName, String upgradeName, String appliesTo, String ingredients, String baseSlotDescription, String additionsSlotDescription) {
    }
}

