/*
 * Decompiled with CFR 0.152.
 */
package top.syshub.mtfd;

import com.google.common.hash.Funnels;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.PrimitiveSink;
import com.mojang.logging.LogUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.class_3521;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class MultiThreadDownloader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int THREAD_COUNT = 16;
    private static final int MIN_CHUNK_SIZE = 0x100000;

    /*
     * Exception decompiling
     */
    public static Path downloadFile(Path path, URL uRL, Map<String, String> map, HashFunction hashFunction, @Nullable HashCode hashCode, int i, Proxy proxy, class_3521.class_9034 downloadProgressListener) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK], 2[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void updateModificationTime(Path path) {
        try {
            Files.setLastModifiedTime(path, FileTime.from(Instant.now()));
        }
        catch (IOException var2) {
            LOGGER.warn("Failed to update modification time of {}", (Object)path, (Object)var2);
        }
    }

    private static HashCode hashFile(Path path, HashFunction hashFunction) throws IOException {
        Hasher hasher = hashFunction.newHasher();
        try (OutputStream outputStream = Funnels.asOutputStream((PrimitiveSink)hasher);
             InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            inputStream.transferTo(outputStream);
        }
        return hasher.hash();
    }

    private static boolean checkExistingFile(Path path, HashFunction hashFunction, HashCode hashCode) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            HashCode hashCode2 = MultiThreadDownloader.hashFile(path, hashFunction);
            if (hashCode2.equals((Object)hashCode)) {
                return true;
            }
            LOGGER.warn("Mismatched hash of file {}, expected {} but found {}", new Object[]{path, hashCode, hashCode2});
        }
        return false;
    }

    private static Path cachedFilePath(Path path, HashCode hashCode) {
        return path.resolve(hashCode.toString());
    }

    private static HashCode downloadAndHashMultiThreaded(URL url, HashFunction hashFunction, int maxSize, class_3521.class_9034 downloadProgressListener, Path path, Map<String, String> headers, Proxy proxy) throws IOException {
        try {
            return MultiThreadDownloader.downloadMultiThreaded(url, hashFunction, maxSize, downloadProgressListener, path, headers, proxy);
        }
        catch (Exception e) {
            LOGGER.warn("Multi-threaded download failed, falling back to single-threaded: {}", (Object)e.getMessage());
            return MultiThreadDownloader.downloadSingleThreaded(url, hashFunction, maxSize, downloadProgressListener, path, headers, proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashCode downloadMultiThreaded(URL url, HashFunction hashFunction, int maxSize, class_3521.class_9034 downloadProgressListener, Path path, Map<String, String> headers, Proxy proxy) throws IOException {
        boolean supportsRanges;
        long fileSize;
        HttpURLConnection connection = (HttpURLConnection)url.openConnection(proxy);
        connection.setRequestMethod("HEAD");
        headers.forEach(connection::setRequestProperty);
        try {
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new IOException("Server returned " + responseCode + " for HEAD request");
            }
            fileSize = connection.getContentLengthLong();
            String acceptRanges = connection.getHeaderField("Accept-Ranges");
            supportsRanges = "bytes".equalsIgnoreCase(acceptRanges);
        }
        finally {
            connection.disconnect();
        }
        if (!supportsRanges || fileSize < 0x200000L) {
            throw new IOException("File size unknown, server doesn't support ranges, or file too small for multi-threading");
        }
        if (fileSize > (long)maxSize) {
            throw new IOException("Filesize is bigger than maximum allowed (file is " + fileSize + ", limit is " + maxSize + ")");
        }
        long chunkSize = Math.max(0x100000L, fileSize / 16L);
        int actualThreadCount = (int)Math.min(16L, (fileSize + chunkSize - 1L) / chunkSize);
        LOGGER.info("Starting multi-threaded download with {} threads, file size: {} bytes", (Object)actualThreadCount, (Object)fileSize);
        ExecutorService executor = Executors.newFixedThreadPool(actualThreadCount);
        ArrayList<Future<ChunkResult>> futures = new ArrayList<Future<ChunkResult>>();
        AtomicLong totalDownloaded = new AtomicLong(0L);
        try {
            for (int i = 0; i < actualThreadCount; ++i) {
                long start = (long)i * chunkSize;
                long end = Math.min(start + chunkSize - 1L, fileSize - 1L);
                futures.add(executor.submit(() -> MultiThreadDownloader.downloadChunk(url, start, end, headers, proxy, totalDownloaded, downloadProgressListener)));
            }
            ArrayList<ChunkResult> chunks = new ArrayList<ChunkResult>();
            for (Future hashCode : futures) {
                chunks.add((ChunkResult)hashCode.get());
            }
            chunks.sort(Comparator.comparingLong(c -> c.start));
            Hasher hasher = hashFunction.newHasher();
            try (OutputStream outputStream = Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                for (ChunkResult chunk : chunks) {
                    outputStream.write(chunk.data);
                    hasher.putBytes(chunk.data);
                }
            }
            HashCode hashCode = hasher.hash();
            return hashCode;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException("Multi-threaded download failed", e);
        }
        finally {
            executor.shutdown();
            try {
                if (!executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    executor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                executor.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    private static ChunkResult downloadChunk(URL url, long start, long end, Map<String, String> headers, Proxy proxy, AtomicLong totalDownloaded, class_3521.class_9034 downloadProgressListener) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection(proxy);
        connection.setInstanceFollowRedirects(true);
        headers.forEach(connection::setRequestProperty);
        connection.setRequestProperty("Range", "bytes=" + start + "-" + end);
        try {
            ChunkResult chunkResult;
            block11: {
                InputStream inputStream = connection.getInputStream();
                try {
                    int bytesRead;
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    byte[] buffer = new byte[8192];
                    while ((bytesRead = inputStream.read(buffer)) != -1) {
                        if (Thread.interrupted()) {
                            throw new IOException("Download interrupted");
                        }
                        outputStream.write(buffer, 0, bytesRead);
                        long downloaded = totalDownloaded.addAndGet(bytesRead);
                        downloadProgressListener.method_55498(downloaded);
                    }
                    chunkResult = new ChunkResult(start, outputStream.toByteArray());
                    if (inputStream == null) break block11;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return chunkResult;
        }
        finally {
            connection.disconnect();
        }
    }

    /*
     * Exception decompiling
     */
    private static HashCode downloadSingleThreaded(URL url, HashFunction hashFunction, int maxSize, class_3521.class_9034 downloadProgressListener, Path path, Map<String, String> headers, Proxy proxy) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private record ChunkResult(long start, byte[] data) {
    }
}

