/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.immersiveoverlays.overlay;

import cc.cassian.immersiveoverlays.ModClient;
import cc.cassian.immersiveoverlays.compat.CuriosCompat;
import cc.cassian.immersiveoverlays.compat.ModCompat;
import cc.cassian.immersiveoverlays.compat.SophisticatedBackpacksCompat;
import cc.cassian.immersiveoverlays.compat.TravelersBackpackCompat;
import cc.cassian.immersiveoverlays.config.ModConfig;
import cc.cassian.immersiveoverlays.helpers.ModLists;
import cc.cassian.immersiveoverlays.overlay.BiomeOverlay;
import cc.cassian.immersiveoverlays.overlay.ClockOverlay;
import cc.cassian.immersiveoverlays.overlay.CompassOverlay;
import cc.cassian.immersiveoverlays.overlay.SpeedOverlay;
import cc.cassian.immersiveoverlays.overlay.TemperatureOverlay;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class OverlayHelpers {
    public static final int textureSize = 256;
    public static final ResourceLocation TEXTURE = ModClient.locate("textures/gui/overlay.png");
    public static boolean showWaila = false;
    static boolean hasBeenToggled = false;

    public static void renderBackground(PoseStack guiGraphics, int windowWidth, int fontWidth, int xPlacement, int xOffset, int yPlacement, int tooltipSize, boolean leftAlign) {
        if (ModConfig.get().render_background) {
            int textureOffset = OverlayHelpers.getTextureOffsetFromSize(tooltipSize);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            int yPlacementWithOffset = yPlacement - 4;
            int endCapOffset = 197;
            int xPlacementWithOffset = xPlacement - xOffset - 4;
            int endCapXPlacement = OverlayHelpers.getEndCapPlacement(windowWidth, fontWidth, leftAlign);
            int uWidth = fontWidth + xOffset + 4;
            OverlayHelpers.blit(guiGraphics, xPlacementWithOffset, yPlacementWithOffset, 0, textureOffset, uWidth, tooltipSize, 256, 256);
            OverlayHelpers.blit(guiGraphics, endCapXPlacement, yPlacementWithOffset, 197, textureOffset, 3, tooltipSize, 256, 256);
        }
    }

    public static int getTextureOffsetFromSize(int textureSize) {
        if (textureSize == 16) {
            return 7;
        }
        if (textureSize == 21) {
            return 111;
        }
        if (textureSize == 25) {
            return 25;
        }
        if (textureSize == 35) {
            return 51;
        }
        if (textureSize == 36) {
            return 132;
        }
        return 0;
    }

    public static void checkInventoryForOverlays(Minecraft minecraft) {
        if ((ModConfig.get().compass_enable || ModConfig.get().clock_enable || ModConfig.get().biome_enable || ModConfig.get().temperature_enable) && minecraft.f_91073_ != null) {
            OverlayHelpers.checkInventoryForItems((Player)minecraft.f_91074_);
        }
    }

    public static boolean playerHasPotions(Player player, boolean leftAlign) {
        if (!ModConfig.get().moved_by_effects) {
            return false;
        }
        if (!leftAlign) {
            return false;
        }
        return !player.m_21220_().isEmpty();
    }

    public static int moveBy(Player player) {
        boolean hasBeneficial = player.m_21220_().stream().anyMatch(p -> p.m_19544_().m_19486_());
        boolean hasNegative = player.m_21220_().stream().anyMatch(p -> !p.m_19544_().m_19486_());
        if (hasNegative) {
            return 42;
        }
        if (hasBeneficial) {
            return 16;
        }
        return 0;
    }

    public static boolean shouldCancelRender(Minecraft mc) {
        if (mc.f_91066_.f_92062_) {
            return true;
        }
        if (!ModConfig.get().enabled) {
            return true;
        }
        if (ModConfig.get().hide_from_debug) {
            boolean debug = mc.f_91066_.f_92063_;
            return debug;
        }
        return false;
    }

    private static void findImportantContainerContents(ItemStack container) {
        List<ItemStack> list = OverlayHelpers.getContainerContents(container).toList();
        for (ItemStack itemStack : list) {
            if (ModConfig.get().search_containers_for_containers) {
                OverlayHelpers.isImportantItemOrContainer(itemStack);
                continue;
            }
            OverlayHelpers.isImportantItem(itemStack);
        }
    }

    private static void isImportantItem(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return;
        }
        Item item = itemStack.m_41720_();
        if (ModLists.compass_x_items.contains(item)) {
            CompassOverlay.showX = true;
        }
        if (ModLists.compass_y_items.contains(item)) {
            CompassOverlay.showY = true;
        }
        if (ModLists.compass_z_items.contains(item)) {
            CompassOverlay.showZ = true;
        }
        if (ModLists.clock_items.contains(item)) {
            ClockOverlay.showTime = true;
        }
        if (ModLists.weather_items.contains(item)) {
            ClockOverlay.showWeather = true;
        }
        if (ModLists.biome_items.contains(item)) {
            BiomeOverlay.showBiome = true;
        }
        if (ModLists.season_items.contains(item)) {
            ClockOverlay.showSeason = true;
        }
        if (ModLists.temperature_items.contains(item)) {
            TemperatureOverlay.showTemperature = true;
        }
        if (ModLists.speed_items.contains(item)) {
            SpeedOverlay.showSpeed = true;
        }
        if (ModLists.waila_items.contains(item)) {
            showWaila = true;
        }
    }

    public static void checkInventoryForItems(Player player) {
        if (ModConfig.get().require_item) {
            OverlayHelpers.setOverlays(false);
            if (player == null) {
                return;
            }
            OverlayHelpers.isImportantItemOrContainer(player.m_21206_());
            if (ModConfig.get().require_item_in_hand) {
                OverlayHelpers.isImportantItemOrContainer(player.m_21205_());
            } else {
                player.m_6168_().forEach(OverlayHelpers::isImportantItemOrContainer);
                if (ModCompat.CURIOS) {
                    CuriosCompat.checkForImportantAccessories(player);
                }
                if (ModCompat.TRAVELERS_BACKPACK) {
                    TravelersBackpackCompat.checkForImportantAccessories(player);
                }
                OverlayHelpers.checkInventoryForStack(player.m_150109_());
            }
        } else {
            OverlayHelpers.setOverlays(true);
        }
    }

    private static void setOverlays(boolean b) {
        CompassOverlay.showX = b;
        CompassOverlay.showY = b;
        CompassOverlay.showZ = b;
        ClockOverlay.showTime = b;
        ClockOverlay.showWeather = b;
        BiomeOverlay.showBiome = b;
        ClockOverlay.showSeason = b;
        TemperatureOverlay.showTemperature = b;
        SpeedOverlay.showSpeed = b;
        showWaila = b;
    }

    public static void isImportantItemOrContainer(ItemStack stack) {
        OverlayHelpers.isImportantItem(stack);
        if (OverlayHelpers.isContainer(stack)) {
            OverlayHelpers.findImportantContainerContents(stack);
        }
        if (ModCompat.SOPHISTICATED_BACKPACKS) {
            SophisticatedBackpacksCompat.checkBackpackContents(stack);
        }
    }

    public static Stream<ItemStack> getContainerContents(ItemStack stack) {
        if (!OverlayHelpers.isContainer(stack)) {
            return Stream.empty();
        }
        CompoundTag compoundtag = stack.m_41783_();
        if (compoundtag == null) {
            return Stream.empty();
        }
        if (compoundtag.m_128441_("Items")) {
            ListTag listtag = compoundtag.m_128437_("Items", 10);
            return listtag.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_);
        }
        if (compoundtag.m_128441_("BlockEntityTag")) {
            CompoundTag compound = compoundtag.m_128469_("BlockEntityTag");
            ListTag listtag = compound.m_128437_("Items", 10);
            return listtag.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_);
        }
        return Stream.empty();
    }

    public static boolean isContainer(ItemStack stack) {
        if (!ModConfig.get().search_containers) {
            return false;
        }
        if (stack.m_41619_()) {
            return false;
        }
        CompoundTag compoundtag = stack.m_41783_();
        if (compoundtag == null) {
            return false;
        }
        if (compoundtag.m_128441_("Items")) {
            return true;
        }
        if (compoundtag.m_128441_("BlockEntityTag") && compoundtag.m_128469_("BlockEntityTag").m_128441_("Items")) {
            return true;
        }
        return true;
    }

    public static boolean checkInventoryForItem(Inventory inventory, Item item, boolean value) {
        if (value) {
            return true;
        }
        return OverlayHelpers.checkInventoryForStack(inventory, item) != ItemStack.f_41583_;
    }

    public static void checkInventoryForStack(Inventory inventory) {
        for (ItemStack stack : inventory.f_35974_) {
            OverlayHelpers.isImportantItem(stack);
            if (!OverlayHelpers.isContainer(stack)) continue;
            OverlayHelpers.findImportantContainerContents(stack);
        }
    }

    public static ItemStack checkInventoryForStack(Inventory inventory, Item item) {
        for (ItemStack stack : inventory.f_35974_) {
            if (stack.m_150930_(item)) {
                return stack;
            }
            if (item != null && stack.m_150930_(item)) {
                return stack;
            }
            if (!OverlayHelpers.isContainer(stack)) continue;
            List<ItemStack> contents = OverlayHelpers.getContainerContents(stack).toList();
            for (ItemStack content : contents) {
                if (item == null || !content.m_150930_(item)) continue;
                return content;
            }
        }
        return ItemStack.f_41583_;
    }

    public static int getPlacement(int windowWidth, int fontWidth, boolean leftAlign) {
        if (leftAlign) {
            return 9;
        }
        return windowWidth - 2 - fontWidth;
    }

    public static int getEndCapPlacement(int windowWidth, int fontWidth, boolean leftAlign) {
        if (leftAlign) {
            return fontWidth + 8;
        }
        return windowWidth - 4;
    }

    public static void drawString(PoseStack poseStack, Font font, Component text, int x, int y, Integer color) {
        GuiComponent.m_93243_((PoseStack)poseStack, (Font)font, (Component)text, (int)x, (int)y, (int)color);
    }

    public static void drawString(PoseStack poseStack, Font font, String text, int x, int y, Integer color) {
        GuiComponent.m_93236_((PoseStack)poseStack, (Font)font, (String)text, (int)x, (int)y, (int)color);
    }

    public static void renderOverlays(PoseStack hud) {
        CompassOverlay.renderGameOverlayEvent(hud);
        ClockOverlay.renderGameOverlayEvent(hud);
        BiomeOverlay.renderGameOverlayEvent(hud);
        TemperatureOverlay.renderGameOverlayEvent(hud);
        SpeedOverlay.renderGameOverlayEvent(hud);
    }

    public static void blit(PoseStack guiGraphics, int x, int y, int uOffset, int vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        OverlayHelpers.blit(guiGraphics, TEXTURE, x, y, uOffset, vOffset, uWidth, vHeight, textureWidth, textureHeight);
    }

    public static void blit(PoseStack guiGraphics, ResourceLocation texture, int x, int y, int uOffset, int vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        GuiComponent.m_93143_((PoseStack)guiGraphics, (int)x, (int)y, (int)0, (float)uOffset, (float)vOffset, (int)uWidth, (int)vHeight, (int)textureWidth, (int)textureHeight);
    }

    public static void blitSprite(PoseStack guiGraphics, ResourceLocation texture, int x, int y) {
        OverlayHelpers.blitSprite(guiGraphics, texture, x, y, 16);
    }

    public static void blitSprite(PoseStack guiGraphics, ResourceLocation texture, int x, int y, int size) {
        OverlayHelpers.blit(guiGraphics, texture, x, y, 0, 0, size, size, size, size);
    }

    public static void checkKeybind() {
        if (ModClient.overlayToggle.m_90857_()) {
            if (!hasBeenToggled) {
                ModConfig.get().enabled = !ModConfig.get().enabled;
                hasBeenToggled = true;
            }
        } else {
            hasBeenToggled = false;
        }
    }
}

