/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.immersiveoverlays.overlay;

import cc.cassian.immersiveoverlays.ModClient;
import cc.cassian.immersiveoverlays.compat.ColdSweatCompat;
import cc.cassian.immersiveoverlays.compat.FabricCompat;
import cc.cassian.immersiveoverlays.compat.LegendarySurvivalOverhaulCompat;
import cc.cassian.immersiveoverlays.compat.ModCompat;
import cc.cassian.immersiveoverlays.compat.ToughAsNailsCompat;
import cc.cassian.immersiveoverlays.config.ModConfig;
import cc.cassian.immersiveoverlays.helpers.TextHelpers;
import cc.cassian.immersiveoverlays.overlay.OverlayHelpers;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import org.apache.commons.lang3.text.WordUtils;

public class TemperatureOverlay {
    public static boolean showTemperature = false;

    public static void renderGameOverlayEvent(PoseStack poseStack) {
        if (!showTemperature || !ModConfig.get().temperature_enable) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (OverlayHelpers.shouldCancelRender(mc)) {
            return;
        }
        if (mc.f_91074_ == null) {
            return;
        }
        TemperaturePair temperature = TemperatureOverlay.getTemperature(mc.f_91074_);
        int xOffset = 3;
        int iconOffset = 0;
        if (ModConfig.get().temperature_icons) {
            iconOffset = 17;
        }
        int tooltipSize = 21;
        int yPlacement = ModConfig.get().temperature_vertical_position;
        int textYPlacement = yPlacement + 2;
        int fontWidth = mc.f_91062_.m_92852_((FormattedText)temperature.component) + iconOffset;
        int windowWidth = mc.m_91268_().m_85445_();
        int xPlacement = OverlayHelpers.getPlacement(windowWidth, fontWidth, ModConfig.get().temperature_horizontal_position_left);
        OverlayHelpers.renderBackground(poseStack, windowWidth, fontWidth, xPlacement, xOffset, yPlacement, tooltipSize, ModConfig.get().temperature_horizontal_position_left);
        OverlayHelpers.drawString(poseStack, mc.f_91062_, temperature.component(), xPlacement - xOffset + iconOffset, textYPlacement, temperature.color());
        if (showTemperature && ModConfig.get().temperature_icons) {
            OverlayHelpers.blitSprite(poseStack, ModClient.locate("textures/gui/" + temperature.texture() + ".png"), xPlacement - xOffset - 1, textYPlacement - 3);
        }
    }

    public static TemperaturePair getTemperature(LocalPlayer player) {
        if (ModCompat.TOUGH_AS_NAILS && ModConfig.get().compat_tough_as_nails_temperature && ToughAsNailsCompat.isTemperatureEnabled()) {
            String temperature;
            String sprite = switch (temperature = ToughAsNailsCompat.getAmbientTemperature(player)) {
                case "ICY" -> "heat_0";
                case "COLD" -> "heat_1";
                case "WARM" -> "heat_4";
                case "HOT" -> "heat_6";
                default -> "heat_2";
            };
            return new TemperaturePair((Component)TextHelpers.literal(WordUtils.capitalizeFully((String)temperature)), -1, sprite);
        }
        if (ModCompat.COLD_SWEAT && ModConfig.get().compat_cold_sweat_temperature) {
            return ColdSweatCompat.getTemperaturePair(player);
        }
        if (ModCompat.LEGENDARY_SURVIVAL_OVERHAUL && ModConfig.get().compat_legendary_survival_overhaul_temperature) {
            String temperature;
            String sprite = switch (temperature = LegendarySurvivalOverhaulCompat.getAmbientTemperature(player)) {
                case "FROSTBITE" -> "heat_0";
                case "COLD" -> "heat_1";
                case "HOT" -> "heat_4";
                case "HEAT_STROKE" -> "heat_6";
                default -> "heat_2";
            };
            return new TemperaturePair((Component)Component.m_237113_((String)WordUtils.capitalizeFully((String)temperature)), -1, sprite);
        }
        Level level = player.f_19853_;
        return TemperatureOverlay.getBiomeTemperature((Holder<Biome>)level.m_204166_(player.m_20183_()));
    }

    public static TemperaturePair getBiomeTemperature(Holder<Biome> biome) {
        if (ModCompat.FABRIC_API) {
            return FabricCompat.getBiomeTemperatureFromTag(biome);
        }
        return TemperatureOverlay.getBiomeTemperature(((Biome)biome.m_203334_()).m_47554_());
    }

    public static TemperaturePair getBiomeTemperature(float temperature) {
        if (temperature >= 2.0f) {
            return new TemperaturePair((Component)TextHelpers.translatable("gui.c.temperature.hot"), ModConfig.get().temperature_hot_colour, "heat_4");
        }
        if ((double)temperature <= 0.2) {
            return new TemperaturePair((Component)TextHelpers.translatable("gui.c.temperature.cold"), ModConfig.get().temperature_cold_colour, "heat_0");
        }
        return new TemperaturePair((Component)TextHelpers.translatable("gui.c.temperature.temperate"), ModConfig.get().temperature_temperate_colour, "heat_1");
    }

    public record TemperaturePair(Component component, Integer color, String texture) {
    }
}

