/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.immersiveoverlays.overlay;

import cc.cassian.immersiveoverlays.ModClient;
import cc.cassian.immersiveoverlays.compat.AccessoriesCompat;
import cc.cassian.immersiveoverlays.compat.ModCompat;
import cc.cassian.immersiveoverlays.compat.SophisticatedBackpacksCompat;
import cc.cassian.immersiveoverlays.compat.TravelersBackpackCompat;
import cc.cassian.immersiveoverlays.config.ModConfig;
import cc.cassian.immersiveoverlays.helpers.ModLists;
import cc.cassian.immersiveoverlays.overlay.BiomeOverlay;
import cc.cassian.immersiveoverlays.overlay.ClockOverlay;
import cc.cassian.immersiveoverlays.overlay.CompassOverlay;
import cc.cassian.immersiveoverlays.overlay.SpeedOverlay;
import cc.cassian.immersiveoverlays.overlay.TemperatureOverlay;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.ItemContainerContents;

public class OverlayHelpers {
    public static final int textureSize = 256;
    public static final ResourceLocation TEXTURE = ModClient.locate("textures/gui/overlay.png");
    public static boolean showWaila = false;
    static boolean hasBeenToggled = false;

    public static void renderBackground(GuiGraphics guiGraphics, int windowWidth, int fontWidth, int xPlacement, int xOffset, int yPlacement, int tooltipSize, boolean leftAlign) {
        if (ModConfig.get().render_background) {
            int textureOffset = OverlayHelpers.getTextureOffsetFromSize(tooltipSize);
            int yPlacementWithOffset = yPlacement - 4;
            int endCapOffset = 197;
            int xPlacementWithOffset = xPlacement - xOffset - 4;
            int endCapXPlacement = OverlayHelpers.getEndCapPlacement(windowWidth, fontWidth, leftAlign);
            int uWidth = fontWidth + xOffset + 4;
            OverlayHelpers.blit(guiGraphics, xPlacementWithOffset, yPlacementWithOffset, 0, textureOffset, uWidth, tooltipSize, 256, 256);
            OverlayHelpers.blit(guiGraphics, endCapXPlacement, yPlacementWithOffset, 197, textureOffset, 3, tooltipSize, 256, 256);
        }
    }

    public static int getTextureOffsetFromSize(int textureSize) {
        if (textureSize == 16) {
            return 7;
        }
        if (textureSize == 21) {
            return 111;
        }
        if (textureSize == 25) {
            return 25;
        }
        if (textureSize == 35) {
            return 51;
        }
        if (textureSize == 36) {
            return 132;
        }
        return 0;
    }

    public static void checkInventoryForOverlays(Minecraft minecraft) {
        if ((ModConfig.get().compass_enable || ModConfig.get().clock_enable || ModConfig.get().biome_enable || ModConfig.get().temperature_enable) && minecraft.level != null) {
            OverlayHelpers.checkInventoryForItems((Player)minecraft.player);
        }
    }

    public static boolean playerHasPotions(Player player, boolean leftAlign) {
        if (!ModConfig.get().moved_by_effects) {
            return false;
        }
        if (!leftAlign) {
            return false;
        }
        return !player.getActiveEffects().isEmpty();
    }

    public static int moveBy(Player player) {
        boolean hasBeneficial = player.getActiveEffects().stream().anyMatch(p -> ((MobEffect)p.getEffect().value()).isBeneficial());
        boolean hasNegative = player.getActiveEffects().stream().anyMatch(p -> !((MobEffect)p.getEffect().value()).isBeneficial());
        if (hasNegative) {
            return 42;
        }
        if (hasBeneficial) {
            return 16;
        }
        return 0;
    }

    public static boolean shouldCancelRender(Minecraft mc) {
        if (mc.options.hideGui) {
            return true;
        }
        if (!ModConfig.get().enabled) {
            return true;
        }
        if (ModConfig.get().hide_from_debug) {
            boolean debug = mc.getDebugOverlay().showDebugScreen();
            return debug;
        }
        return false;
    }

    private static void findImportantContainerContents(ItemStack container) {
        List<ItemStack> list = OverlayHelpers.getContainerContents(container).toList();
        for (ItemStack itemStack : list) {
            if (ModConfig.get().search_containers_for_containers) {
                OverlayHelpers.isImportantItemOrContainer(itemStack);
                continue;
            }
            OverlayHelpers.isImportantItem(itemStack);
        }
    }

    private static void isImportantItem(ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return;
        }
        Item item = itemStack.getItem();
        if (ModLists.compass_x_items.contains(item)) {
            CompassOverlay.showX = true;
        }
        if (ModLists.compass_y_items.contains(item)) {
            CompassOverlay.showY = true;
        }
        if (ModLists.compass_z_items.contains(item)) {
            CompassOverlay.showZ = true;
        }
        if (ModLists.clock_items.contains(item)) {
            ClockOverlay.showTime = true;
        }
        if (ModLists.weather_items.contains(item)) {
            ClockOverlay.showWeather = true;
        }
        if (ModLists.biome_items.contains(item)) {
            BiomeOverlay.showBiome = true;
        }
        if (ModLists.season_items.contains(item)) {
            ClockOverlay.showSeason = true;
        }
        if (ModLists.temperature_items.contains(item)) {
            TemperatureOverlay.showTemperature = true;
        }
        if (ModLists.speed_items.contains(item)) {
            SpeedOverlay.showSpeed = true;
        }
        if (ModLists.waila_items.contains(item)) {
            showWaila = true;
        }
    }

    public static void checkInventoryForItems(Player player) {
        if (ModConfig.get().require_item) {
            OverlayHelpers.setOverlays(false);
            if (player == null) {
                return;
            }
            OverlayHelpers.isImportantItemOrContainer(player.getOffhandItem());
            if (ModConfig.get().require_item_in_hand) {
                OverlayHelpers.isImportantItemOrContainer(player.getMainHandItem());
            } else {
                player.getArmorSlots().forEach(OverlayHelpers::isImportantItemOrContainer);
                if (ModCompat.ACCESSORIES) {
                    AccessoriesCompat.checkForImportantAccessories(player);
                }
                if (ModCompat.TRAVELERS_BACKPACK) {
                    TravelersBackpackCompat.checkForImportantAccessories(player);
                }
                OverlayHelpers.checkInventoryForStack(player.getInventory());
            }
        } else {
            OverlayHelpers.setOverlays(true);
        }
    }

    private static void setOverlays(boolean b) {
        CompassOverlay.showX = b;
        CompassOverlay.showY = b;
        CompassOverlay.showZ = b;
        ClockOverlay.showTime = b;
        ClockOverlay.showWeather = b;
        BiomeOverlay.showBiome = b;
        ClockOverlay.showSeason = b;
        TemperatureOverlay.showTemperature = b;
        SpeedOverlay.showSpeed = b;
        showWaila = b;
    }

    public static void isImportantItemOrContainer(ItemStack stack) {
        OverlayHelpers.isImportantItem(stack);
        if (OverlayHelpers.isContainer(stack)) {
            OverlayHelpers.findImportantContainerContents(stack);
        }
        if (ModCompat.SOPHISTICATED_BACKPACKS) {
            SophisticatedBackpacksCompat.checkBackpackContents(stack);
        }
    }

    public static Stream<ItemStack> getContainerContents(ItemStack stack) {
        ItemContainerContents containerContents;
        if (!OverlayHelpers.isContainer(stack)) {
            return Stream.empty();
        }
        DataComponentMap components = stack.getComponents();
        if (components.has(DataComponents.BUNDLE_CONTENTS)) {
            BundleContents bundleContents = (BundleContents)components.get(DataComponents.BUNDLE_CONTENTS);
            if (bundleContents != null) {
                return bundleContents.itemCopyStream();
            }
        } else if (components.has(DataComponents.CONTAINER) && (containerContents = (ItemContainerContents)components.get(DataComponents.CONTAINER)) != null) {
            return containerContents.stream();
        }
        return Stream.empty();
    }

    public static boolean isContainer(ItemStack stack) {
        if (!ModConfig.get().search_containers) {
            return false;
        }
        if (stack.isEmpty()) {
            return false;
        }
        DataComponentMap components = stack.getComponents();
        if (components.has(DataComponents.BUNDLE_CONTENTS)) {
            return true;
        }
        if (components.has(DataComponents.CONTAINER)) {
            return true;
        }
        return true;
    }

    public static boolean checkInventoryForItem(Inventory inventory, Item item, boolean value) {
        if (value) {
            return true;
        }
        return OverlayHelpers.checkInventoryForStack(inventory, item) != ItemStack.EMPTY;
    }

    public static void checkInventoryForStack(Inventory inventory) {
        for (ItemStack stack : inventory.items) {
            OverlayHelpers.isImportantItem(stack);
            if (!OverlayHelpers.isContainer(stack)) continue;
            OverlayHelpers.findImportantContainerContents(stack);
        }
    }

    public static ItemStack checkInventoryForStack(Inventory inventory, Item item) {
        for (ItemStack stack : inventory.items) {
            if (stack.is(item)) {
                return stack;
            }
            if (item != null && stack.is(item)) {
                return stack;
            }
            if (!OverlayHelpers.isContainer(stack)) continue;
            List<ItemStack> contents = OverlayHelpers.getContainerContents(stack).toList();
            for (ItemStack content : contents) {
                if (item == null || !content.is(item)) continue;
                return content;
            }
        }
        return ItemStack.EMPTY;
    }

    public static int getPlacement(int windowWidth, int fontWidth, boolean leftAlign) {
        if (leftAlign) {
            return 9;
        }
        return windowWidth - 2 - fontWidth;
    }

    public static int getEndCapPlacement(int windowWidth, int fontWidth, boolean leftAlign) {
        if (leftAlign) {
            return fontWidth + 8;
        }
        return windowWidth - 4;
    }

    public static void drawString(GuiGraphics poseStack, Font font, Component text, int x, int y, Integer color) {
        poseStack.drawString(font, text, x, y, color.intValue());
    }

    public static void drawString(GuiGraphics poseStack, Font font, String text, int x, int y, Integer color) {
        poseStack.drawString(font, text, x, y, color.intValue());
    }

    public static void renderOverlays(GuiGraphics hud) {
        CompassOverlay.renderGameOverlayEvent(hud);
        ClockOverlay.renderGameOverlayEvent(hud);
        BiomeOverlay.renderGameOverlayEvent(hud);
        TemperatureOverlay.renderGameOverlayEvent(hud);
        SpeedOverlay.renderGameOverlayEvent(hud);
    }

    public static void blit(GuiGraphics guiGraphics, int x, int y, int uOffset, int vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        OverlayHelpers.blit(guiGraphics, TEXTURE, x, y, uOffset, vOffset, uWidth, vHeight, textureWidth, textureHeight);
    }

    public static void blit(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y, int uOffset, int vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        guiGraphics.blit(texture, x, y, 0, (float)uOffset, (float)vOffset, uWidth, vHeight, textureWidth, textureHeight);
    }

    public static void blitSprite(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y) {
        OverlayHelpers.blitSprite(guiGraphics, texture, x, y, 16);
    }

    public static void blitSprite(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y, int size) {
        OverlayHelpers.blit(guiGraphics, texture, x, y, 0, 0, size, size, size, size);
    }

    public static void checkKeybind() {
        if (ModClient.overlayToggle.isDown()) {
            if (!hasBeenToggled) {
                ModConfig.get().enabled = !ModConfig.get().enabled;
                hasBeenToggled = true;
            }
        } else {
            hasBeenToggled = false;
        }
    }
}

