package cc.cassian.immersiveoverlays.overlay;


import cc.cassian.immersiveoverlays.compat.ModCompat;
import cc.cassian.immersiveoverlays.config.ModConfig;
import cc.cassian.immersiveoverlays.helpers.ModHelpers;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_332;

import static cc.cassian.immersiveoverlays.overlay.BiomeOverlay.*;

public class CompassOverlay {
    public static boolean showX = false;
    public static boolean showY = false;
    public static boolean showZ = false;

    //? if >1.20 {
    public static void renderGameOverlayEvent(class_332 guiGraphics) {
        //?} else {
        /*public static void renderGameOverlayEvent(PoseStack guiGraphics) {
         *///?}
        boolean showBiomeIcon = ModConfig.get().biome_enable && BiomeOverlay.showBiome && ModConfig.get().biome_reduced_info && ModConfig.get().biome_icons;
        if (!showX && !showY && !showZ)
            return;
        if (!ModConfig.get().compass_enable)
            return;

        var mc = class_310.method_1551();
        if (OverlayHelpers.shouldCancelRender(mc))
            return;

        ArrayList<String> coords = new ArrayList<>();

        class_2338 pos;
        if (mc.field_1724 != null) pos = mc.field_1724.method_24515();
        else return;

        String x = String.format("%d", pos.method_10263());
        String y = String.format("%d", pos.method_10264());
        String z = String.format("%d", pos.method_10260());
        var width = Integer.max(x.length(), z.length());
        width = Integer.max(width, y.length());
        if (showX) {
            x = StringUtils.leftPad(x, width);
            coords.add("§%sX:§r %s".formatted(ModHelpers.getColour(ModConfig.get().compass_x_colour), x));
        }
        if (showY) {
            y = StringUtils.leftPad(y, width);
            coords.add("§%sY:§r %s".formatted(ModHelpers.getColour(ModConfig.get().compass_y_colour), y));
        }
        if (showZ) {
            z = StringUtils.leftPad(z, width);
            coords.add("§%sZ:§r %s".formatted(ModHelpers.getColour(ModConfig.get().compass_z_colour), z));
        }
        int xOffset = 3;
        int yPlacement = ModConfig.get().compass_vertical_position;
        int iconXOffset = 0;
        int iconYOffset = 0;
        if (showBiomeIcon) {
            iconXOffset += 20;
        }
        int fontWidth = mc.field_1772.method_1727(StringUtils.repeat("a", width+2))+iconXOffset;

        if (ModConfig.get().avoid_overlapping) {
            if (!(ClockOverlay.showTime || ClockOverlay.showWeather) || !ModConfig.get().clock_enable || (ModConfig.get().clock_horizontal_position_left != ModConfig.get().compass_horizontal_position_left)) {
                yPlacement = yPlacement - 15;
            }
            if (ClockOverlay.showWeather && (ModConfig.get().clock_horizontal_position_left == ModConfig.get().compass_horizontal_position_left)) {
                yPlacement = yPlacement + 9;
            }
            if (!BiomeOverlay.showBiome || !ModConfig.get().biome_enable || ModConfig.get().biome_reduced_info || (ModConfig.get().biome_horizontal_position_left != ModConfig.get().compass_horizontal_position_left)) {
                yPlacement = yPlacement - 20;
            }
            if (!ClockOverlay.shouldShowSeasons()) {
                yPlacement = yPlacement - 15;
            }
        }
        if (OverlayHelpers.playerHasPotions(mc.field_1724, ModConfig.get().compass_horizontal_position_left)) {
            yPlacement += OverlayHelpers.moveBy(mc.field_1724);
        }

        int tooltipSize = 16;  // only depth gauge
        if (coords.size() == 2 || (coords.size() == 1 && showBiomeIcon)) {
            tooltipSize = 25;
            iconYOffset = 3;
        } else if (coords.size() == 3) {
            tooltipSize = 35;
            iconYOffset = 5;
        }

        int windowWidth = mc.method_22683().method_4486();
        int xPlacement = OverlayHelpers.getPlacement(windowWidth, fontWidth, ModConfig.get().compass_horizontal_position_left);
        // render background
        OverlayHelpers.renderBackground(guiGraphics, windowWidth, fontWidth, xPlacement, xOffset, yPlacement, tooltipSize, ModConfig.get().compass_horizontal_position_left);
        if (showBiomeIcon) {
            var sprite = getBiomeSprite(getId(getBiome(mc.field_1724)), true);
            OverlayHelpers.blit(guiGraphics, sprite, xPlacement-xOffset-1, yPlacement+iconYOffset, 0, 0, 16, 16, 16, 16);
            xOffset -= 16;
        }
        // render text
        for (String text : coords) {
            OverlayHelpers.drawString(guiGraphics, mc.field_1772, text, xPlacement-xOffset, yPlacement, ModConfig.get().compass_text_colour);
            yPlacement += mc.field_1772.field_2000;
        }
    }
}