/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.immersiveoverlays.helpers;

import cc.cassian.immersiveoverlays.helpers.TextHelpers;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;

public class ModHelpers {
    public static Component fieldName(Field field) {
        return TextHelpers.translatable("config.immersiveoverlays.config." + field.getName());
    }

    public static <T> T fieldGet(Object instance, Field field) {
        try {
            return (T)field.get(instance);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Consumer<T> fieldSetter(Object instance, Field field) {
        return t -> {
            try {
                field.set(instance, t);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static Component fieldTooltip(Field field) {
        String key = "config.%s.config.%s.tooltip".formatted("immersiveoverlays", field.getName());
        if (I18n.exists((String)"config.%s.config.%s.tooltip".formatted("immersiveoverlays", field.getName()))) {
            return TextHelpers.translatable(key);
        }
        return TextHelpers.empty();
    }

    public static char getColour(String colour) {
        String replacedColour;
        int length = colour.length();
        if (length == 1) {
            return colour.charAt(0);
        }
        return switch (replacedColour = colour.toLowerCase().replace(" ", "_")) {
            case "black", "dark_blue", "dark_green", "dark_red", "dark_purple", "blue", "green", "aqua", "red", "yellow", "white" -> Objects.requireNonNullElse(ChatFormatting.getByName((String)colour), ChatFormatting.GRAY).getChar();
            case "pink", "light_purple" -> Objects.requireNonNullElse(ChatFormatting.getByName((String)"light_purple"), ChatFormatting.GRAY).getChar();
            case "dark_gray", "dark_grey" -> Objects.requireNonNullElse(ChatFormatting.getByName((String)"dark_gray"), ChatFormatting.GRAY).getChar();
            case "cyan", "dark_aqua" -> Objects.requireNonNullElse(ChatFormatting.getByName((String)"dark_aqua"), ChatFormatting.GRAY).getChar();
            case "orange", "gold", "dark_yellow" -> Objects.requireNonNullElse(ChatFormatting.getByName((String)"gold"), ChatFormatting.GRAY).getChar();
            default -> ChatFormatting.GRAY.getChar();
        };
    }
}

