/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.immersiveoverlays.overlay;

import cc.cassian.immersiveoverlays.config.ModConfig;
import cc.cassian.immersiveoverlays.overlay.OverlayHelpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class ClockOverlay {
    public static boolean showTime = false;
    public static boolean showWeather = false;

    public static void renderGameOverlayEvent(GuiGraphics poseStack) {
        int yPlacement;
        if (!showWeather && !showTime) {
            return;
        }
        if (!ModConfig.get().clock_enable) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        Object time = ClockOverlay.getTime(mc.level.getDayTime());
        if (((String)time).length() == 4) {
            time = " " + (String)time;
        }
        int xOffset = 3;
        int iconOffset = 0;
        int textureOffset = 7;
        int tooltipSize = 16;
        int textYPlacement = yPlacement = ModConfig.get().clock_vertical_position;
        if (showWeather) {
            if (showTime) {
                iconOffset = 20;
            }
            textureOffset = 111;
            tooltipSize = 21;
            textYPlacement += 2;
        }
        int fontWidth = mc.font.width((String)time) + iconOffset;
        if (mc.player == null) {
            return;
        }
        if (OverlayHelpers.playerHasPotions((Player)mc.player)) {
            yPlacement += OverlayHelpers.moveBy((Player)mc.player);
            textYPlacement += OverlayHelpers.moveBy((Player)mc.player);
        }
        int windowWidth = mc.getWindow().getGuiScaledWidth();
        int xPlacement = OverlayHelpers.getPlacement(windowWidth, fontWidth);
        OverlayHelpers.renderBackground(poseStack, windowWidth, fontWidth, xPlacement, xOffset, yPlacement, textureOffset, tooltipSize);
        if (showTime) {
            poseStack.drawString(mc.font, (String)time, xPlacement - xOffset + iconOffset, textYPlacement, 0xE0E0E0);
        }
        if (showWeather) {
            int spriteOffset = ClockOverlay.getWeather((Player)mc.player);
            poseStack.blit(OverlayHelpers.TEXTURE, xPlacement - xOffset - 1, yPlacement - 1, 0, (float)spriteOffset, 95.0f, 16, 16, 256, 256);
        }
    }

    public static int getWeather(Player player) {
        Level level = player.level();
        Biome biome = (Biome)level.getBiome(player.blockPosition()).value();
        long time = level.getDayTime() % 24000L;
        Biome.Precipitation precipitation = biome.getPrecipitationAt(player.blockPosition());
        boolean snows = biome.coldEnoughToSnow(player.blockPosition());
        if (!level.dimensionType().natural()) {
            return 124;
        }
        if (level.isThundering()) {
            if (snows) {
                return 92;
            }
            if (precipitation.equals((Object)Biome.Precipitation.NONE)) {
                return 108;
            }
            return 76;
        }
        if (level.isRaining()) {
            if (snows) {
                return 92;
            }
            if (precipitation.equals((Object)Biome.Precipitation.NONE)) {
                return 108;
            }
            return 60;
        }
        if (time >= 12500L && time <= 13500L) {
            return 30;
        }
        if (time >= 13500L && time <= 22500L) {
            return 46;
        }
        if (time >= 23000L || time <= 300L) {
            return 15;
        }
        return 0;
    }

    public static String getTime(float dayTime) {
        int time = (int)(dayTime + 6000.0f) % 24000;
        int m = (int)((float)time % 1000.0f / 1000.0f * 60.0f);
        int h = time / 1000;
        String a = "";
        if (!Boolean.valueOf(ModConfig.get().clock_24_hour).booleanValue()) {
            String string = a = time < 12000 ? " AM" : " PM";
            if ((h %= 12) == 0) {
                h = 12;
            }
        }
        return h + ":" + (m < 10 ? "0" : "") + m + a;
    }
}

