/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.immersiveoverlays.overlay;

import cc.cassian.immersiveoverlays.compat.MapAtlasesCompat;
import cc.cassian.immersiveoverlays.compat.ModCompat;
import cc.cassian.immersiveoverlays.config.ModConfig;
import cc.cassian.immersiveoverlays.helpers.ModHelpers;
import cc.cassian.immersiveoverlays.overlay.ClockOverlay;
import cc.cassian.immersiveoverlays.overlay.OverlayHelpers;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.StringUtils;

public class CompassOverlay {
    public static boolean showXZ = false;
    public static boolean showY = false;

    public static void renderGameOverlayEvent(GuiGraphics poseStack) {
        if (!showXZ && !showY) {
            return;
        }
        if (!ModConfig.get().compass_enable) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (OverlayHelpers.debug(mc)) {
            return;
        }
        ArrayList<String> coords = new ArrayList<String>();
        if (mc.player == null) {
            return;
        }
        BlockPos pos = mc.player.blockPosition();
        if (ModConfig.get().compass_hide_when_similar_mods_present && ModCompat.MAP_ATLASES && MapAtlasesCompat.showingCoords((Player)mc.player)) {
            return;
        }
        String x = String.format("%d", pos.getX());
        String y = String.format("%d", pos.getY());
        String z = String.format("%d", pos.getZ());
        int width = Integer.max(x.length(), z.length());
        width = Integer.max(width, y.length());
        x = StringUtils.leftPad((String)x, (int)width);
        y = StringUtils.leftPad((String)y, (int)width);
        z = StringUtils.leftPad((String)z, (int)width);
        int xOffset = 3;
        int yPlacement = ModConfig.get().compass_vertical_position;
        int fontWidth = mc.font.width(StringUtils.repeat((String)"a", (int)(width + 2)));
        if (showXZ) {
            coords.add("\u00a7%sX:\u00a7f %s".formatted(Character.valueOf(ModHelpers.getColour(ModConfig.get().compass_x_colour)), x));
            if (showY) {
                coords.add("\u00a7%sY:\u00a7f %s".formatted(Character.valueOf(ModHelpers.getColour(ModConfig.get().compass_y_colour)), y));
            }
            coords.add("\u00a7%sZ:\u00a7f %s".formatted(Character.valueOf(ModHelpers.getColour(ModConfig.get().compass_z_colour)), z));
        } else if (showY) {
            coords.add("\u00a7%sY:\u00a7f %s".formatted(Character.valueOf(ModHelpers.getColour(ModConfig.get().compass_y_colour)), y));
        }
        if (!ClockOverlay.showTime && !ClockOverlay.showWeather || !ModConfig.get().clock_enable) {
            yPlacement -= 15;
        }
        if (ClockOverlay.showWeather) {
            yPlacement += 9;
        }
        if (OverlayHelpers.playerHasPotions((Player)mc.player)) {
            yPlacement += OverlayHelpers.moveBy((Player)mc.player);
        }
        int textureOffset = 7;
        int tooltipSize = 16;
        if (showXZ & showY) {
            textureOffset = 51;
            tooltipSize = 35;
        } else if (showXZ) {
            textureOffset = 25;
            tooltipSize = 25;
        }
        int windowWidth = mc.getWindow().getGuiScaledWidth();
        int xPlacement = OverlayHelpers.getPlacement(windowWidth, fontWidth);
        OverlayHelpers.renderBackground(poseStack, windowWidth, fontWidth, xPlacement, xOffset, yPlacement, textureOffset, tooltipSize);
        for (String text : coords) {
            poseStack.drawString(mc.font, text, xPlacement - xOffset, yPlacement, 0xE0E0E0);
            Objects.requireNonNull(mc.font);
            yPlacement += 9;
        }
    }
}

