/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.immersiveoverlays.overlay;

import cc.cassian.immersiveoverlays.ModClient;
import cc.cassian.immersiveoverlays.compat.AccessoriesCompat;
import cc.cassian.immersiveoverlays.compat.ModCompat;
import cc.cassian.immersiveoverlays.config.ModConfig;
import cc.cassian.immersiveoverlays.helpers.ModLists;
import cc.cassian.immersiveoverlays.helpers.ModTags;
import cc.cassian.immersiveoverlays.overlay.ClockOverlay;
import cc.cassian.immersiveoverlays.overlay.CompassOverlay;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.ItemContainerContents;

public class OverlayHelpers {
    public static final int textureSize = 256;
    public static final ResourceLocation TEXTURE = ModClient.locate("textures/gui/overlay.png");

    public static void renderBackground(GuiGraphics guiGraphics, int windowWidth, int fontWidth, int xPlacement, int xOffset, int yPlacement, int textureOffset, int tooltipSize) {
        if (ModConfig.get().render_background) {
            int yPlacementWithOffset = yPlacement - 4;
            int endCapOffset = 197;
            guiGraphics.blit(TEXTURE, xPlacement - xOffset - 4, yPlacementWithOffset, 0, 0.0f, (float)textureOffset, fontWidth + xOffset + 4, tooltipSize, 256, 256);
            guiGraphics.blit(TEXTURE, OverlayHelpers.getEndCapPlacement(windowWidth, fontWidth), yPlacementWithOffset, 0, 197.0f, (float)textureOffset, 3, tooltipSize, 256, 256);
        }
    }

    public static void checkInventoryForOverlays(Minecraft minecraft) {
        if ((ModConfig.get().compass_enable || ModConfig.get().clock_enable) && minecraft.level != null) {
            OverlayHelpers.checkInventoryForItems((Player)minecraft.player);
        }
    }

    public static boolean playerHasPotions(Player player) {
        if (!ModConfig.get().moved_by_effects) {
            return false;
        }
        return !player.getActiveEffects().isEmpty();
    }

    public static int moveBy(Player player) {
        boolean hasBeneficial = player.getActiveEffects().stream().anyMatch(p -> ((MobEffect)p.getEffect().value()).isBeneficial());
        boolean hasNegative = player.getActiveEffects().stream().anyMatch(p -> !((MobEffect)p.getEffect().value()).isBeneficial());
        if (hasNegative) {
            return 42;
        }
        if (hasBeneficial) {
            return 16;
        }
        return 0;
    }

    public static boolean debug(Minecraft mc) {
        boolean debug = mc.getDebugOverlay().showDebugScreen();
        return debug && (Boolean)mc.options.reducedDebugInfo().get() == false;
    }

    private static void findImportantContainerContents(ItemStack container) {
        List<ItemStack> list = OverlayHelpers.getContainerContents(container).toList();
        for (ItemStack itemStack : list) {
            OverlayHelpers.isImportantItem(itemStack);
        }
    }

    private static void isImportantItem(ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return;
        }
        Item item = itemStack.getItem();
        if (ModLists.compass_items.contains(item)) {
            CompassOverlay.showXZ = true;
        }
        if (ModLists.compass_depth_items.contains(item)) {
            CompassOverlay.showY = true;
        }
        if (ModLists.clock_items.contains(item)) {
            ClockOverlay.showTime = true;
        }
        if (ModLists.weather_items.contains(item)) {
            ClockOverlay.showWeather = true;
        }
    }

    public static void checkInventoryForItems(Player player) {
        CompassOverlay.showXZ = false;
        CompassOverlay.showY = false;
        ClockOverlay.showTime = false;
        ClockOverlay.showWeather = false;
        if (player == null) {
            return;
        }
        if (ModConfig.get().compass_enable || ModConfig.get().clock_enable) {
            OverlayHelpers.isImportantItemOrContainer(player.getOffhandItem());
            if (ModConfig.get().require_item_in_hand) {
                OverlayHelpers.isImportantItemOrContainer(player.getMainHandItem());
            } else {
                player.getArmorSlots().forEach(OverlayHelpers::isImportantItemOrContainer);
                if (ModCompat.ACCESSORIES) {
                    AccessoriesCompat.checkForImportantAccessories(player);
                }
                OverlayHelpers.checkInventoryForStack(player.getInventory());
            }
        }
    }

    public static void isImportantItemOrContainer(ItemStack stack) {
        OverlayHelpers.isImportantItem(stack);
        if (OverlayHelpers.isContainer(stack)) {
            OverlayHelpers.findImportantContainerContents(stack);
        }
    }

    public static Stream<ItemStack> getContainerContents(ItemStack stack) {
        if (!OverlayHelpers.isContainer(stack)) {
            return Stream.empty();
        }
        DataComponentMap components = stack.getComponents();
        if (components.has(DataComponents.BUNDLE_CONTENTS)) {
            BundleContents bundleContents = (BundleContents)components.get(DataComponents.BUNDLE_CONTENTS);
            return bundleContents.itemCopyStream();
        }
        if (components.has(DataComponents.CONTAINER)) {
            ItemContainerContents containerContents = (ItemContainerContents)components.get(DataComponents.CONTAINER);
            return containerContents.stream();
        }
        return Stream.empty();
    }

    public static boolean isContainer(ItemStack stack) {
        if (!ModConfig.get().search_containers) {
            return false;
        }
        if (stack.isEmpty()) {
            return false;
        }
        if (stack.is(ModTags.CONTAINERS)) {
            return true;
        }
        DataComponentMap components = stack.getComponents();
        if (components.has(DataComponents.BUNDLE_CONTENTS)) {
            return true;
        }
        if (components.has(DataComponents.CONTAINER)) {
            return true;
        }
        return true;
    }

    public static boolean checkInventoryForItem(Inventory inventory, Item item, boolean value) {
        if (value) {
            return true;
        }
        return OverlayHelpers.checkInventoryForStack(inventory, item) != ItemStack.EMPTY;
    }

    public static void checkInventoryForStack(Inventory inventory) {
        for (ItemStack stack : inventory.items) {
            OverlayHelpers.isImportantItem(stack);
            if (!OverlayHelpers.isContainer(stack)) continue;
            OverlayHelpers.findImportantContainerContents(stack);
        }
    }

    public static ItemStack checkInventoryForStack(Inventory inventory, Item item) {
        for (ItemStack stack : inventory.items) {
            if (stack.is(item)) {
                return stack;
            }
            if (item != null && stack.is(item)) {
                return stack;
            }
            if (!OverlayHelpers.isContainer(stack)) continue;
            List<ItemStack> contents = OverlayHelpers.getContainerContents(stack).toList();
            for (ItemStack content : contents) {
                if (item == null || !content.is(item)) continue;
                return content;
            }
        }
        return ItemStack.EMPTY;
    }

    public static int getPlacement(int windowWidth, int fontWidth) {
        if (ModConfig.get().align_left) {
            return 9;
        }
        return windowWidth - 2 - fontWidth;
    }

    public static int getEndCapPlacement(int windowWidth, int fontWidth) {
        if (ModConfig.get().align_left) {
            return fontWidth + 8;
        }
        return windowWidth - 4;
    }
}

