/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.immersiveoverlays.overlay;

import cc.cassian.immersiveoverlays.ModClient;
import cc.cassian.immersiveoverlays.compat.FabricSeasonsCompat;
import cc.cassian.immersiveoverlays.compat.ModCompat;
import cc.cassian.immersiveoverlays.compat.SereneSeasonsCompat;
import cc.cassian.immersiveoverlays.compat.SimpleSeasonsCompat;
import cc.cassian.immersiveoverlays.config.ModConfig;
import cc.cassian.immersiveoverlays.helpers.TextHelpers;
import cc.cassian.immersiveoverlays.overlay.OverlayHelpers;
import java.util.Locale;
import net.minecraft.class_1074;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_638;
import org.apache.commons.lang3.text.WordUtils;

public class ClockOverlay {
    public static boolean showTime = false;
    public static boolean showWeather = false;
    public static boolean showSeason = false;

    public static void renderGameOverlayEvent(class_332 guiGraphics) {
        int yPlacement;
        if (!showWeather && !showTime && !ClockOverlay.shouldShowSeasons() || !ModConfig.get().clock_enable) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (OverlayHelpers.shouldCancelRender(mc)) {
            return;
        }
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        Object time = "Hi! ";
        if (showTime && ((String)(time = mc.field_1687.method_8597().comp_645() ? ClockOverlay.getTime(mc.field_1687.method_8532()) : "????")).length() == 4) {
            time = " " + (String)time;
        }
        int xOffset = 3;
        int iconXOffset = 0;
        int tooltipSize = 16;
        int iconYPlacement = yPlacement = ModConfig.get().clock_vertical_position;
        int textYPlacement = yPlacement;
        if (showWeather) {
            if (showTime) {
                iconXOffset = 20;
            }
            tooltipSize = 21;
            textYPlacement += 2;
        }
        if (ClockOverlay.shouldShowSeasons()) {
            if (showTime) {
                tooltipSize = 36;
            } else {
                tooltipSize = 21;
                textYPlacement += 2;
            }
            iconXOffset = 20;
        }
        int fontWidth = mc.field_1772.method_1727((String)time) + iconXOffset;
        class_5250 seasonText = null;
        String seasonString = null;
        if (ClockOverlay.shouldShowSeasons()) {
            seasonString = ClockOverlay.getSeason(mc.field_1687, mc.field_1724.method_24515());
            seasonText = TextHelpers.translatableWithFallback("gui.c.season." + seasonString, WordUtils.capitalizeFully((String)seasonString.replace("_", " ")));
            fontWidth = Integer.max(mc.field_1772.method_1727((String)time), mc.field_1772.method_27525((class_5348)seasonText)) + iconXOffset;
        }
        if (OverlayHelpers.playerHasPotions((class_1657)mc.field_1724, ModConfig.get().biome_horizontal_position_left)) {
            iconYPlacement += OverlayHelpers.moveBy((class_1657)mc.field_1724);
            textYPlacement += OverlayHelpers.moveBy((class_1657)mc.field_1724);
        }
        int windowWidth = mc.method_22683().method_4486();
        int xPlacement = OverlayHelpers.getPlacement(windowWidth, fontWidth, ModConfig.get().clock_horizontal_position_left);
        OverlayHelpers.renderBackground(guiGraphics, windowWidth, fontWidth, xPlacement, xOffset, yPlacement, tooltipSize, ModConfig.get().clock_horizontal_position_left);
        if (showTime) {
            OverlayHelpers.drawString(guiGraphics, mc.field_1772, (String)time, xPlacement - xOffset + iconXOffset, textYPlacement, (Integer)ModConfig.get().clock_text_colour);
        }
        if (showWeather) {
            int spriteOffset = ClockOverlay.getWeather((class_1657)mc.field_1724);
            OverlayHelpers.blit(guiGraphics, xPlacement - xOffset - 1, iconYPlacement - 1, spriteOffset, 95, 16, 16, 256, 256);
        }
        if (ClockOverlay.shouldShowSeasons()) {
            int seasonTextYPlacement = textYPlacement;
            if (showTime) {
                seasonTextYPlacement += 15;
            }
            OverlayHelpers.drawString(guiGraphics, mc.field_1772, (class_2561)seasonText, xPlacement - xOffset + iconXOffset, seasonTextYPlacement, (Integer)ModConfig.get().clock_text_colour);
            assert (seasonString != null);
            class_2960 sprite = ClockOverlay.getSprite(seasonString.toLowerCase(Locale.ROOT));
            OverlayHelpers.blitSprite(guiGraphics, sprite, xPlacement - xOffset - 1, seasonTextYPlacement - 4);
        }
    }

    public static class_2960 getSprite(String season) {
        String spriteText = season.replace("early_", "").replace("mid_", "").replace("late_", "").replace("autumn", "fall");
        return ModClient.locate("textures/gui/" + spriteText + ".png");
    }

    public static int getWeather(class_1657 player) {
        class_1937 level = player.method_73183();
        class_1959 biome = (class_1959)level.method_23753(player.method_24515()).comp_349();
        long time = level.method_8532() % 24000L;
        class_1959.class_1963 precipitation = biome.method_48162(player.method_24515(), level.method_8615());
        boolean snows = biome.method_33599(player.method_24515(), level.method_8615());
        if (!level.method_8597().comp_645()) {
            return 124;
        }
        if (level.method_8546()) {
            if (snows) {
                return 92;
            }
            if (precipitation.equals((Object)class_1959.class_1963.field_9384)) {
                return 108;
            }
            return 76;
        }
        if (level.method_8419()) {
            if (snows) {
                return 92;
            }
            if (precipitation.equals((Object)class_1959.class_1963.field_9384)) {
                return 108;
            }
            return 60;
        }
        if (time >= 12500L && time <= 13500L) {
            return 30;
        }
        if (time >= 13500L && time <= 22500L) {
            return 46;
        }
        if (time >= 23000L || time <= 300L) {
            return 15;
        }
        return 0;
    }

    public static String getTime(float dayTime) {
        StringBuilder currentTime = new StringBuilder();
        if (ModConfig.get().clock_day_count) {
            int day = (int)(dayTime / 24000.0f);
            currentTime.append(class_1074.method_4662((String)"gui.c.day", (Object[])new Object[]{day}));
            if (ModConfig.get().clock_current_time) {
                currentTime.append(", ");
            }
        }
        if (ModConfig.get().clock_current_time) {
            int time = (int)(dayTime + 6000.0f) % 24000;
            int m = (int)((float)time % 1000.0f / 1000.0f * 60.0f);
            int hour = time / 1000;
            String a = "";
            if (!Boolean.valueOf(ModConfig.get().clock_24_hour).booleanValue()) {
                String string = a = time < 12000 ? " AM" : " PM";
                if ((hour %= 12) == 0) {
                    hour = 12;
                }
            }
            currentTime.append(hour).append(":").append(m < 10 ? "0" : "").append(m).append(a);
        }
        return currentTime.toString();
    }

    public static boolean shouldShowSeasons() {
        if (ModConfig.get().clock_seasons && showSeason) {
            return ModCompat.SERENE_SEASONS || ModCompat.SIMPLE_SEASONS || ModCompat.FABRIC_SEASONS || ModCompat.TERRAFIRMACRAFT || ModCompat.ECLIPTIC_SEASONS;
        }
        return false;
    }

    public static String getSeason(class_638 level, class_2338 pos) {
        String season = "unknown";
        if (ModConfig.get().clock_seasons && showSeason) {
            if (ModCompat.SERENE_SEASONS && ModConfig.get().compat_serene_seasons) {
                season = SereneSeasonsCompat.getSeason(level, pos);
            }
            if (ModCompat.FABRIC_SEASONS && ModConfig.get().compat_fabric_seasons) {
                season = FabricSeasonsCompat.getSeason(level);
            }
            if (ModCompat.SIMPLE_SEASONS && ModConfig.get().compat_simple_seasons) {
                season = SimpleSeasonsCompat.getSeason(level);
            }
        }
        return season;
    }
}

