package cc.cassian.immersiveoverlays.overlay;

import cc.cassian.immersiveoverlays.ModClient;
import cc.cassian.immersiveoverlays.compat.*;
import cc.cassian.immersiveoverlays.helpers.ModLists;
import cc.cassian.immersiveoverlays.config.ModConfig;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_10799;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_9276;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import net.minecraft.class_9848;

public class OverlayHelpers {
    public static final int textureSize = 256;
    public static final class_2960 TEXTURE = ModClient.locate("textures/gui/overlay.png");
    public static boolean showWaila = false;

    //? if >1.20 {
    public static void renderBackground(class_332 guiGraphics, int windowWidth, int fontWidth, int xPlacement, int xOffset, int yPlacement, int tooltipSize, boolean leftAlign) {
        //?} else {
        /*public static void renderBackground(PoseStack guiGraphics, int windowWidth, int fontWidth, int xPlacement, int xOffset, int yPlacement, int tooltipSize, boolean leftAlign) {
         *///?}
        if (ModConfig.get().render_background) {
            int textureOffset = OverlayHelpers.getTextureOffsetFromSize(tooltipSize);
            //? if <1.20
            /*RenderSystem.setShaderTexture(0, OverlayHelpers.TEXTURE);*/
            final int yPlacementWithOffset = yPlacement-4;
            final int endCapOffset = 197;
            final int xPlacementWithOffset = xPlacement-xOffset-4;
            final int endCapXPlacement = OverlayHelpers.getEndCapPlacement(windowWidth, fontWidth, leftAlign);
            final int uWidth = fontWidth+xOffset+4;
            OverlayHelpers.blit(guiGraphics, xPlacementWithOffset, yPlacementWithOffset, 0, textureOffset, uWidth, tooltipSize, OverlayHelpers.textureSize, OverlayHelpers.textureSize);
            // render endcap
            OverlayHelpers.blit(guiGraphics, endCapXPlacement, yPlacementWithOffset, endCapOffset, textureOffset, 3, tooltipSize, OverlayHelpers.textureSize, OverlayHelpers.textureSize);
        }
    }

    public static int getTextureOffsetFromSize(int textureSize) {
        if (textureSize == 16) {
            return 7;
        } else if (textureSize == 21) {
            return 111;
        } else if (textureSize == 25) {
            return 25;
        } else if (textureSize == 35) {
            return 51;
        } else if (textureSize == 36) {
            return 131;
        }
        else return 0;
    }

    public static void checkInventoryForOverlays(class_310 minecraft){
        if ((ModConfig.get().compass_enable || ModConfig.get().clock_enable || ModConfig.get().biome_enable || ModConfig.get().temperature_enable)  && minecraft.field_1687 != null) {
            OverlayHelpers.checkInventoryForItems(minecraft.field_1724);
        }
    }

    public static boolean playerHasPotions(class_1657 player, boolean leftAlign) {
        if (!ModConfig.get().moved_by_effects) return false;
        if (!leftAlign) return false;
        // Technically, we should check whether these are ambient,
        // but Map Atlases doesn't and still covers our overlay.
        // return Player.areAllEffectsAmbient(player.getActiveEffects());
        return !player.method_6026().isEmpty();
    }

    public static int moveBy(class_1657 player) {
        //? if >1.21 {
        boolean hasBeneficial =
                player.method_6026().stream().anyMatch(p -> p.method_5579().comp_349().method_5573());
        boolean hasNegative =
                player.method_6026().stream().anyMatch(p -> !p.method_5579().comp_349().method_5573());
        //?} else {
        /*boolean hasBeneficial =
                player.getActiveEffects().stream().anyMatch(p -> p.getEffect().isBeneficial());
        boolean hasNegative =
                player.getActiveEffects().stream().anyMatch(p -> !p.getEffect().isBeneficial());

        *///?}
        if (hasNegative) {
            return 42;
        } else if (hasBeneficial) {
            return 16;
        }
        else return 0;
    }

    public static boolean shouldCancelRender(class_310 mc) {
        if (mc.field_1690.field_1842) return true;
        if (!ModConfig.get().enabled) return true;
        if (ModConfig.get().hide_from_debug) {
            //? if >1.21 {
            var debug = mc.method_53526().method_53536();
             //?} else {
            /*var debug = mc.options.renderDebug;
            *///?}
            return debug;
        }
        return false;
    }

    private static void findImportantContainerContents(class_1799 container) {
        List<class_1799> list = getContainerContents(container).toList();
        for (class_1799 itemStack : list) {
            if (ModConfig.get().search_containers_for_containers) {
                isImportantItemOrContainer(itemStack);
            } else {
                isImportantItem(itemStack);
            }
        }
    }

    private static void isImportantItem(class_1799 itemStack) {
        if (itemStack.method_7960())
            return;
        var item = itemStack.method_7909();
        if (ModLists.compass_x_items.contains(item))
            CompassOverlay.showX = true;
        if (ModLists.compass_y_items.contains(item))
            CompassOverlay.showY = true;
        if (ModLists.compass_z_items.contains(item))
            CompassOverlay.showZ = true;
        if (ModLists.clock_items.contains(item))
            ClockOverlay.showTime = true;
        if (ModLists.weather_items.contains(item))
            ClockOverlay.showWeather = true;
        if (ModLists.biome_items.contains(item))
            BiomeOverlay.showBiome = true;
        if (ModLists.season_items.contains(item))
            ClockOverlay.showSeason = true;
        if (ModLists.temperature_items.contains(item))
            TemperatureOverlay.showTemperature = true;
        if (ModLists.speed_items.contains(item))
            SpeedOverlay.showSpeed = true;
        if (ModLists.waila_items.contains(item))
            showWaila = true;
    }

    public static void checkInventoryForItems(class_1657 player) {
        if (ModConfig.get().require_item) {
            setOverlays(false);
            if (player == null)
                return;
            isImportantItemOrContainer(player.method_6079());
            if (ModConfig.get().require_item_in_hand) {
                isImportantItemOrContainer(player.method_6047());
            } else {
                //? if <1.21.5 {
                /*player.getArmorSlots().forEach((OverlayHelpers::isImportantItemOrContainer));
                *///?} else {
                for (class_1304 value : class_1304.values()) {
                    isImportantItemOrContainer(player.method_6118(value));
                }
                //?}
                //? if >1.20 {
                if (ModCompat.ACCESSORIES)
                    AccessoriesCompat.checkForImportantAccessories(player);
                //?}
                //? if forge {
                /*if (ModCompat.CURIOS)
                    CuriosCompat.checkForImportantAccessories(player);
                *///?}
                //? if fabric {
                if (ModCompat.TRINKETS)
                    TrinketsCompat.checkForImportantAccessories(player);
                //?}
                if (ModCompat.TRAVELERS_BACKPACK)
                    TravelersBackpackCompat.checkForImportantAccessories(player);
                checkInventoryForStack(player.method_31548());
            }
        } else {
            setOverlays(true);
        }
    }

    private static void setOverlays(boolean b) {
        CompassOverlay.showX = b;
        CompassOverlay.showY = b;
        CompassOverlay.showZ = b;
        ClockOverlay.showTime = b;
        ClockOverlay.showWeather = b;
        BiomeOverlay.showBiome = b;
        ClockOverlay.showSeason = b;
        TemperatureOverlay.showTemperature = b;
        SpeedOverlay.showSpeed = b;
        showWaila = b;
    }

    public static void isImportantItemOrContainer(class_1799 stack) {
        isImportantItem(stack);
        if (isContainer(stack)) {
            findImportantContainerContents(stack);
        }
        if (ModCompat.SOPHISTICATED_BACKPACKS) {
            SophisticatedBackpacksCompat.checkBackpackContents(stack);
        }
    }

    public static Stream<class_1799> getContainerContents(class_1799 stack) {
        if (!isContainer(stack)) return Stream.empty();
        //? if >1.20.5 {
        var components = stack.method_57353();
        if (components.method_57832(class_9334.field_49650)) {
            class_9276 bundleContents = components.method_58694(class_9334.field_49650);
            if (bundleContents != null)
                return bundleContents.method_59707();
        }
        else if (components.method_57832(class_9334.field_49622)) {
            class_9288 containerContents = components.method_58694(class_9334.field_49622);
            if (containerContents != null)
                return containerContents.method_57489();
        }
        //?} else {
        /*CompoundTag compoundtag = stack.getTag();
        if (compoundtag == null) {
            return Stream.empty();
        } else {
            if (compoundtag.contains("Items")) {
                ListTag listtag = compoundtag.getList("Items", 10);
                return listtag.stream().map(CompoundTag.class::cast).map(ItemStack::of);
            }
            else if (compoundtag.contains("BlockEntityTag")) {
                var compound = compoundtag.getCompound("BlockEntityTag");
                ListTag listtag = compound.getList("Items", 10);
                return listtag.stream().map(CompoundTag.class::cast).map(ItemStack::of);
            }
        }
        *///?}
        return Stream.empty();
    }

    public static boolean isContainer(class_1799 stack) {
        if (!ModConfig.get().search_containers) return false;
        if (stack.method_7960()) return false;
        //? if >1.20.5 {
        var components = stack.method_57353();
        if (components.method_57832(class_9334.field_49650)) {
            return true;
        }
        else if (components.method_57832(class_9334.field_49622)) {
            return true;
        }
        //?} else {
        /*CompoundTag compoundtag = stack.getTag();
        if (compoundtag == null) {
            return false;
        } else {
            if (compoundtag.contains("Items")) {
                return true;
            }
            else if (compoundtag.contains("BlockEntityTag")) {
                if (compoundtag.getCompound("BlockEntityTag").contains("Items")) {
                    return true;
                }
            }
        }
        *///?}
        return true;
    }

    public static boolean checkInventoryForItem(class_1661 inventory, class_1792 item, boolean value) {
        if (value) return true;
        else return checkInventoryForStack(inventory, item) != class_1799.field_8037;
    }

    public static void checkInventoryForStack(class_1661 inventory) {
        for (class_1799 stack :
            //? if <1.21.5 {
             /*inventory.items
            *///?} else {
                inventory.method_67533()
            //?}
        ) {
            isImportantItem(stack);
            if (isContainer(stack)) {
                findImportantContainerContents(stack);
            }
        }
    }

    public static class_1799 checkInventoryForStack(class_1661 inventory, class_1792 item) {
        for (class_1799 stack :
            //? if <1.21.5 {
             /*inventory.items
            *///?} else {
        inventory.method_67533()
        //?}
        ) {
            if (stack.method_31574(item)) return stack;
            else if (item != null && stack.method_31574(item))
                return stack;
            else if (isContainer(stack)) {
                List<class_1799> contents = getContainerContents(stack).toList();
                for (class_1799 content : contents) {
                    if (item != null && content.method_31574(item))
                        return content;
                }
            }
        }
        return class_1799.field_8037;
    }

    public static int getPlacement(int windowWidth, int fontWidth, boolean leftAlign) {
        if (leftAlign) {
            return 9;
        } else {
            return windowWidth-2-fontWidth;
        }
    }

    public static int getEndCapPlacement(int windowWidth, int fontWidth, boolean leftAlign) {
        if (leftAlign) {
            return fontWidth+8;
        } else {
            return windowWidth-4;
        }
    }

    public static void drawString(
           //? if >1.20 {
          class_332
          //?} else {
          /*PoseStack
          *///?}
          poseStack, class_327 font, class_2561 text, int x, int y, Integer color) {
        //? if >1.21.6
        color = class_9848.method_61334(color);
        //? if >1.20 {
        poseStack.method_27535(font, text, x, y, color);
        //?} else {
        /*GuiComponent.drawString(poseStack, font, text, x, y, color);
         *///?}
    }

    public static void drawString(
          //? if >1.20 {
          class_332
          //?} else {
          /*PoseStack
          *///?}
         poseStack, class_327 font, String text, int x, int y, Integer color) {
        //? if >1.21.6
        color = class_9848.method_61334(color);
        //? if >1.20 {
        poseStack.method_25303(font, text, x, y, color);
        //?} else {
        /*GuiComponent.drawString(poseStack, font, text, x, y, color);
         *///?}
    }

    public static void renderOverlays(
            //? if >1.20 {
            class_332
            //?} else {
            /*PoseStack
             *///?}
                    hud) {
        CompassOverlay.renderGameOverlayEvent(hud);
        ClockOverlay.renderGameOverlayEvent(hud);
        BiomeOverlay.renderGameOverlayEvent(hud);
        TemperatureOverlay.renderGameOverlayEvent(hud);
        SpeedOverlay.renderGameOverlayEvent(hud);
    }

    public static void blit(
           //? if >1.20 {
          class_332
          //?} else {
          /*PoseStack
          *///?}
          guiGraphics, int x, int y, int uOffset, int vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        OverlayHelpers.blit(guiGraphics, TEXTURE, x, y, uOffset, vOffset, uWidth, vHeight, textureWidth, textureHeight);
    }

    public static void blit(
           //? if >1.20 {
          class_332
          //?} else {
          /*PoseStack
          *///?}
          guiGraphics, class_2960 texture, int x, int y, int uOffset, int vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        //? if >1.21.5 {
        guiGraphics.method_25290(class_10799.field_56883, texture,
        //?} else if >1.21.2 {
        /*guiGraphics.blit(RenderType::guiTextured, texture,
         *///?} else if >1.20 {
        /*guiGraphics.blit(texture,
                *///?} else {
            /*RenderSystem.setShaderTexture(0, texture);
               GuiComponent.blit(guiGraphics,
             *///?}
                x, y,
                //? if <1.21.2
                /*0,*/ //z
                //?
                uOffset,
                vOffset, uWidth, vHeight,
                textureWidth, textureHeight);
    }

    public static void blitSprite(
            //? if >1.20 {
            class_332
                    //?} else {
                    /*PoseStack
                     *///?}
                    guiGraphics, class_2960 texture, int x, int y) {
        blitSprite(guiGraphics, texture, x, y, 16);
    }

    public static void blitSprite(
            //? if >1.20 {
            class_332
                    //?} else {
                    /*PoseStack
                     *///?}
                    guiGraphics, class_2960 texture, int x, int y, int size) {
        blit(guiGraphics, texture, x, y, 0, 0, size, size, size, size);
    }

    static boolean hasBeenToggled = false;

    public static void checkKeybind() {
        if (ModClient.overlayToggle.method_1434()) {
            if (!hasBeenToggled) {
                ModConfig.get().enabled = !ModConfig.get().enabled;
                hasBeenToggled = true;
            }
        } else {
            hasBeenToggled = false;
        }
    }
}
