/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.immersiveoverlays.overlay;

import cc.cassian.immersiveoverlays.ModClient;
import cc.cassian.immersiveoverlays.compat.FabricCompat;
import cc.cassian.immersiveoverlays.compat.ModCompat;
import cc.cassian.immersiveoverlays.compat.ThermooCompat;
import cc.cassian.immersiveoverlays.compat.ToughAsNailsCompat;
import cc.cassian.immersiveoverlays.config.ModConfig;
import cc.cassian.immersiveoverlays.helpers.TextHelpers;
import cc.cassian.immersiveoverlays.overlay.OverlayHelpers;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_9779;
import org.apache.commons.lang3.text.WordUtils;

public class TemperatureOverlay {
    public static boolean showTemperature = false;

    public static void renderGameOverlayEvent(class_332 guiGraphics, class_9779 deltaTracker) {
        if (!showTemperature || !ModConfig.get().temperature_enable) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (OverlayHelpers.shouldCancelRender(mc)) {
            return;
        }
        if (mc.field_1724 == null) {
            return;
        }
        TemperaturePair temperature = TemperatureOverlay.getTemperature(mc.field_1724);
        int xOffset = 3;
        int iconOffset = 0;
        if (ModConfig.get().temperature_icons) {
            iconOffset = 17;
        }
        int tooltipSize = 21;
        int yPlacement = ModConfig.get().temperature_vertical_position;
        int textYPlacement = yPlacement + 2;
        int fontWidth = mc.field_1772.method_27525((class_5348)temperature.component) + iconOffset;
        int windowWidth = mc.method_22683().method_4486();
        int xPlacement = OverlayHelpers.getPlacement(windowWidth, fontWidth, ModConfig.get().temperature_horizontal_position_left);
        OverlayHelpers.renderBackground(guiGraphics, windowWidth, fontWidth, xPlacement, xOffset, yPlacement, tooltipSize, ModConfig.get().temperature_horizontal_position_left);
        OverlayHelpers.drawString(guiGraphics, mc.field_1772, temperature.component(), xPlacement - xOffset + iconOffset, textYPlacement, temperature.color());
        if (showTemperature && ModConfig.get().temperature_icons) {
            OverlayHelpers.blitSprite(guiGraphics, ModClient.locate("textures/gui/" + temperature.texture() + ".png"), xPlacement - xOffset - 1, textYPlacement - 3);
        }
    }

    public static TemperaturePair getTemperature(class_746 player) {
        TemperaturePair temperaturePair;
        if (ModCompat.TOUGH_AS_NAILS && ModConfig.get().compat_tough_as_nails_temperature && ToughAsNailsCompat.isTemperatureEnabled()) {
            String temperature;
            String sprite = switch (temperature = ToughAsNailsCompat.getAmbientTemperature(player)) {
                case "ICY" -> "heat_0";
                case "COLD" -> "heat_1";
                case "WARM" -> "heat_4";
                case "HOT" -> "heat_6";
                default -> "heat_2";
            };
            return new TemperaturePair((class_2561)TextHelpers.literal(WordUtils.capitalizeFully((String)temperature)), -1, sprite);
        }
        if (ModCompat.THERMOO && ModConfig.get().compat_thermoo_temperature && (temperaturePair = ThermooCompat.getTemperaturePair(player)) != null) {
            return temperaturePair;
        }
        class_1937 level = player.method_73183();
        return TemperatureOverlay.getBiomeTemperature((class_6880<class_1959>)level.method_23753(player.method_24515()));
    }

    public static TemperaturePair getBiomeTemperature(class_6880<class_1959> biome) {
        if (ModCompat.FABRIC_API) {
            return FabricCompat.getBiomeTemperatureFromTag(biome);
        }
        return TemperatureOverlay.getBiomeTemperature(((class_1959)biome.comp_349()).method_8712());
    }

    public static TemperaturePair getBiomeTemperature(float temperature) {
        if (temperature >= 2.0f) {
            return new TemperaturePair((class_2561)TextHelpers.translatable("gui.c.temperature.hot"), ModConfig.get().temperature_hot_colour, "heat_4");
        }
        if ((double)temperature <= 0.2) {
            return new TemperaturePair((class_2561)TextHelpers.translatable("gui.c.temperature.cold"), ModConfig.get().temperature_cold_colour, "heat_0");
        }
        return new TemperaturePair((class_2561)TextHelpers.translatable("gui.c.temperature.temperate"), ModConfig.get().temperature_temperate_colour, "heat_1");
    }

    public record TemperaturePair(class_2561 component, Integer color, String texture) {
    }
}

