package cc.cassian.immersiveoverlays.compat;

import cc.cassian.immersiveoverlays.config.ModConfig;
import cc.cassian.immersiveoverlays.overlay.TemperatureOverlay;
//? if >1.19
import net.fabricmc.fabric.api.tag.client.v1.ClientTags;
//? if >1.21 {
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags;
import net.minecraft.class_1959;
import net.minecraft.class_2561;
import net.minecraft.class_6880;

public class FabricCompat {
    /**
     * As this is a clientside mod, Fabric API's client tag API is required to read tag information.
     * This can be substituted for the Forgified Fabric API.
     */
    //? if >1.19 {
    public static TemperatureOverlay.TemperaturePair getBiomeTemperatureFromTag(class_6880<class_1959> biomeHolder) {
        if (ClientTags.isInWithLocalFallback(
                //? if >1.21
                ConventionalBiomeTags.IS_HOT
                //? if <1.21
                /*ConventionalBiomeTags.CLIMATE_HOT*/
                ,biomeHolder)) {
            return new TemperatureOverlay.TemperaturePair(class_2561.method_43471("gui.c.temperature.hot"), ModConfig.get().temperature_hot_colour, "heat_4");
        } else if (ClientTags.isInWithLocalFallback(
                //? if >1.21
                ConventionalBiomeTags.IS_COLD
                //? if <1.21
                /*ConventionalBiomeTags.CLIMATE_COLD*/
                , biomeHolder)) {
            return new TemperatureOverlay.TemperaturePair(class_2561.method_43471("gui.c.temperature.cold"), ModConfig.get().temperature_cold_colour, "heat_0");
        } else return new TemperatureOverlay.TemperaturePair(class_2561.method_43471("gui.c.temperature.temperate"), ModConfig.get().temperature_temperate_colour, "heat_1");
    }
    //?}
}
