package cc.cassian.immersiveoverlays.helpers;

import java.lang.reflect.Field;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;

import static cc.cassian.immersiveoverlays.ModClient.MOD_ID;

public class ModHelpers {
    // Automatically generate translation keys for config options.
    public static class_2561 fieldName(Field field) {
        return TextHelpers.translatable("config."+MOD_ID+".config." + field.getName());
    }

    // Get the current value of a config field.
    @SuppressWarnings("unchecked")
    public static <T> T fieldGet(Object instance, Field field) {
        try {
            return (T) field.get(instance);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    // Set a config field.
    public static <T> Consumer<T> fieldSetter(Object instance, Field field) {
        return t -> {
            try {
                field.set(instance, t);
            } catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        };
    }

    /**
     * Automatically generate translation keys for config options.
     */
    public static class_2561 fieldTooltip(Field field) {
        var key = "config.%s.config.%s.tooltip".formatted(MOD_ID, field.getName());
        if (class_1074.method_4663("config.%s.config.%s.tooltip".formatted(MOD_ID, field.getName())))
            return TextHelpers.translatable(key);
        else return TextHelpers.empty();
    }

    /**
     * Used to check what colour the text should be.
     * Adapted from Item Descriptions.
     */
    public static char getColour(String colour) {
        int length = colour.length();
        if (length == 1) {
            return colour.charAt(0);
        }
        else {
            String replacedColour = colour.toLowerCase().replace(" ", "_");
            return switch (replacedColour) {
                case "black", "dark_blue", "dark_green", "dark_red", "dark_purple",
                     "blue", "green", "aqua", "red", "yellow", "white" ->
                        Objects.requireNonNullElse(class_124.method_533(colour), class_124.field_1080).method_36145();
                case "pink", "light_purple" ->
                        Objects.requireNonNullElse(class_124.method_533("light_purple"), class_124.field_1080).method_36145();
                case "dark_gray", "dark_grey" ->
                        Objects.requireNonNullElse(class_124.method_533("dark_gray"), class_124.field_1080).method_36145();
                case "cyan", "dark_aqua" ->
                        Objects.requireNonNullElse(class_124.method_533("dark_aqua"), class_124.field_1080).method_36145();
                case "orange", "gold", "dark_yellow" ->
                        Objects.requireNonNullElse(class_124.method_533("gold"), class_124.field_1080).method_36145();
                default -> class_124.field_1080.method_36145();
            };

        }
    }
}
