/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.immersiveoverlays.overlay;

import cc.cassian.immersiveoverlays.ModClient;
import cc.cassian.immersiveoverlays.compat.AccessoriesCompat;
import cc.cassian.immersiveoverlays.compat.ModCompat;
import cc.cassian.immersiveoverlays.compat.SophisticatedBackpacksCompat;
import cc.cassian.immersiveoverlays.compat.TravelersBackpackCompat;
import cc.cassian.immersiveoverlays.compat.TrinketsCompat;
import cc.cassian.immersiveoverlays.config.ModConfig;
import cc.cassian.immersiveoverlays.helpers.ModLists;
import cc.cassian.immersiveoverlays.overlay.BiomeOverlay;
import cc.cassian.immersiveoverlays.overlay.ClockOverlay;
import cc.cassian.immersiveoverlays.overlay.CompassOverlay;
import cc.cassian.immersiveoverlays.overlay.SpeedOverlay;
import cc.cassian.immersiveoverlays.overlay.TemperatureOverlay;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1291;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_9276;
import net.minecraft.class_9288;
import net.minecraft.class_9323;
import net.minecraft.class_9334;

public class OverlayHelpers {
    public static final int textureSize = 256;
    public static final class_2960 TEXTURE = ModClient.locate("textures/gui/overlay.png");
    public static boolean showWaila = false;
    static boolean hasBeenToggled = false;

    public static void renderBackground(class_332 guiGraphics, int windowWidth, int fontWidth, int xPlacement, int xOffset, int yPlacement, int tooltipSize, boolean leftAlign) {
        if (ModConfig.get().render_background) {
            int textureOffset = OverlayHelpers.getTextureOffsetFromSize(tooltipSize);
            int yPlacementWithOffset = yPlacement - 4;
            int endCapOffset = 197;
            int xPlacementWithOffset = xPlacement - xOffset - 4;
            int endCapXPlacement = OverlayHelpers.getEndCapPlacement(windowWidth, fontWidth, leftAlign);
            int uWidth = fontWidth + xOffset + 4;
            OverlayHelpers.blit(guiGraphics, xPlacementWithOffset, yPlacementWithOffset, 0, textureOffset, uWidth, tooltipSize, 256, 256);
            OverlayHelpers.blit(guiGraphics, endCapXPlacement, yPlacementWithOffset, 197, textureOffset, 3, tooltipSize, 256, 256);
        }
    }

    public static int getTextureOffsetFromSize(int textureSize) {
        if (textureSize == 16) {
            return 7;
        }
        if (textureSize == 21) {
            return 111;
        }
        if (textureSize == 25) {
            return 25;
        }
        if (textureSize == 35) {
            return 51;
        }
        if (textureSize == 36) {
            return 132;
        }
        return 0;
    }

    public static void checkInventoryForOverlays(class_310 minecraft) {
        if ((ModConfig.get().compass_enable || ModConfig.get().clock_enable || ModConfig.get().biome_enable || ModConfig.get().temperature_enable) && minecraft.field_1687 != null) {
            OverlayHelpers.checkInventoryForItems((class_1657)minecraft.field_1724);
        }
    }

    public static boolean playerHasPotions(class_1657 player, boolean leftAlign) {
        if (!ModConfig.get().moved_by_effects) {
            return false;
        }
        if (!leftAlign) {
            return false;
        }
        return !player.method_6026().isEmpty();
    }

    public static int moveBy(class_1657 player) {
        boolean hasBeneficial = player.method_6026().stream().anyMatch(p -> ((class_1291)p.method_5579().comp_349()).method_5573());
        boolean hasNegative = player.method_6026().stream().anyMatch(p -> !((class_1291)p.method_5579().comp_349()).method_5573());
        if (hasNegative) {
            return 42;
        }
        if (hasBeneficial) {
            return 16;
        }
        return 0;
    }

    public static boolean shouldCancelRender(class_310 mc) {
        if (mc.field_1690.field_1842) {
            return true;
        }
        if (!ModConfig.get().enabled) {
            return true;
        }
        if (ModConfig.get().hide_from_debug) {
            boolean debug = mc.method_53526().method_53536();
            return debug;
        }
        return false;
    }

    private static void findImportantContainerContents(class_1799 container) {
        List<class_1799> list = OverlayHelpers.getContainerContents(container).toList();
        for (class_1799 itemStack : list) {
            if (ModConfig.get().search_containers_for_containers) {
                OverlayHelpers.isImportantItemOrContainer(itemStack);
                continue;
            }
            OverlayHelpers.isImportantItem(itemStack);
        }
    }

    private static void isImportantItem(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return;
        }
        class_1792 item = itemStack.method_7909();
        if (ModLists.compass_x_items.contains(item)) {
            CompassOverlay.showX = true;
        }
        if (ModLists.compass_y_items.contains(item)) {
            CompassOverlay.showY = true;
        }
        if (ModLists.compass_z_items.contains(item)) {
            CompassOverlay.showZ = true;
        }
        if (ModLists.clock_items.contains(item)) {
            ClockOverlay.showTime = true;
        }
        if (ModLists.weather_items.contains(item)) {
            ClockOverlay.showWeather = true;
        }
        if (ModLists.biome_items.contains(item)) {
            BiomeOverlay.showBiome = true;
        }
        if (ModLists.season_items.contains(item)) {
            ClockOverlay.showSeason = true;
        }
        if (ModLists.temperature_items.contains(item)) {
            TemperatureOverlay.showTemperature = true;
        }
        if (ModLists.speed_items.contains(item)) {
            SpeedOverlay.showSpeed = true;
        }
        if (ModLists.waila_items.contains(item)) {
            showWaila = true;
        }
    }

    public static void checkInventoryForItems(class_1657 player) {
        if (ModConfig.get().require_item) {
            OverlayHelpers.setOverlays(false);
            if (player == null) {
                return;
            }
            OverlayHelpers.isImportantItemOrContainer(player.method_6079());
            if (ModConfig.get().require_item_in_hand) {
                OverlayHelpers.isImportantItemOrContainer(player.method_6047());
            } else {
                player.method_5661().forEach(OverlayHelpers::isImportantItemOrContainer);
                if (ModCompat.ACCESSORIES) {
                    AccessoriesCompat.checkForImportantAccessories(player);
                }
                if (ModCompat.TRINKETS) {
                    TrinketsCompat.checkForImportantAccessories(player);
                }
                if (ModCompat.TRAVELERS_BACKPACK) {
                    TravelersBackpackCompat.checkForImportantAccessories(player);
                }
                OverlayHelpers.checkInventoryForStack(player.method_31548());
            }
        } else {
            OverlayHelpers.setOverlays(true);
        }
    }

    private static void setOverlays(boolean b) {
        CompassOverlay.showX = b;
        CompassOverlay.showY = b;
        CompassOverlay.showZ = b;
        ClockOverlay.showTime = b;
        ClockOverlay.showWeather = b;
        BiomeOverlay.showBiome = b;
        ClockOverlay.showSeason = b;
        TemperatureOverlay.showTemperature = b;
        SpeedOverlay.showSpeed = b;
        showWaila = b;
    }

    public static void isImportantItemOrContainer(class_1799 stack) {
        OverlayHelpers.isImportantItem(stack);
        if (OverlayHelpers.isContainer(stack)) {
            OverlayHelpers.findImportantContainerContents(stack);
        }
        if (ModCompat.SOPHISTICATED_BACKPACKS) {
            SophisticatedBackpacksCompat.checkBackpackContents(stack);
        }
    }

    public static Stream<class_1799> getContainerContents(class_1799 stack) {
        class_9288 containerContents;
        if (!OverlayHelpers.isContainer(stack)) {
            return Stream.empty();
        }
        class_9323 components = stack.method_57353();
        if (components.method_57832(class_9334.field_49650)) {
            class_9276 bundleContents = (class_9276)components.method_57829(class_9334.field_49650);
            if (bundleContents != null) {
                return bundleContents.method_59707();
            }
        } else if (components.method_57832(class_9334.field_49622) && (containerContents = (class_9288)components.method_57829(class_9334.field_49622)) != null) {
            return containerContents.method_57489();
        }
        return Stream.empty();
    }

    public static boolean isContainer(class_1799 stack) {
        if (!ModConfig.get().search_containers) {
            return false;
        }
        if (stack.method_7960()) {
            return false;
        }
        class_9323 components = stack.method_57353();
        if (components.method_57832(class_9334.field_49650)) {
            return true;
        }
        if (components.method_57832(class_9334.field_49622)) {
            return true;
        }
        return true;
    }

    public static boolean checkInventoryForItem(class_1661 inventory, class_1792 item, boolean value) {
        if (value) {
            return true;
        }
        return OverlayHelpers.checkInventoryForStack(inventory, item) != class_1799.field_8037;
    }

    public static void checkInventoryForStack(class_1661 inventory) {
        for (class_1799 stack : inventory.field_7547) {
            OverlayHelpers.isImportantItem(stack);
            if (!OverlayHelpers.isContainer(stack)) continue;
            OverlayHelpers.findImportantContainerContents(stack);
        }
    }

    public static class_1799 checkInventoryForStack(class_1661 inventory, class_1792 item) {
        for (class_1799 stack : inventory.field_7547) {
            if (stack.method_31574(item)) {
                return stack;
            }
            if (item != null && stack.method_31574(item)) {
                return stack;
            }
            if (!OverlayHelpers.isContainer(stack)) continue;
            List<class_1799> contents = OverlayHelpers.getContainerContents(stack).toList();
            for (class_1799 content : contents) {
                if (item == null || !content.method_31574(item)) continue;
                return content;
            }
        }
        return class_1799.field_8037;
    }

    public static int getPlacement(int windowWidth, int fontWidth, boolean leftAlign) {
        if (leftAlign) {
            return 9;
        }
        return windowWidth - 2 - fontWidth;
    }

    public static int getEndCapPlacement(int windowWidth, int fontWidth, boolean leftAlign) {
        if (leftAlign) {
            return fontWidth + 8;
        }
        return windowWidth - 4;
    }

    public static void drawString(class_332 poseStack, class_327 font, class_2561 text, int x, int y, Integer color) {
        poseStack.method_27535(font, text, x, y, color.intValue());
    }

    public static void drawString(class_332 poseStack, class_327 font, String text, int x, int y, Integer color) {
        poseStack.method_25303(font, text, x, y, color.intValue());
    }

    public static void renderOverlays(class_332 hud) {
        CompassOverlay.renderGameOverlayEvent(hud);
        ClockOverlay.renderGameOverlayEvent(hud);
        BiomeOverlay.renderGameOverlayEvent(hud);
        TemperatureOverlay.renderGameOverlayEvent(hud);
        SpeedOverlay.renderGameOverlayEvent(hud);
    }

    public static void blit(class_332 guiGraphics, int x, int y, int uOffset, int vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        OverlayHelpers.blit(guiGraphics, TEXTURE, x, y, uOffset, vOffset, uWidth, vHeight, textureWidth, textureHeight);
    }

    public static void blit(class_332 guiGraphics, class_2960 texture, int x, int y, int uOffset, int vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        guiGraphics.method_25291(texture, x, y, 0, (float)uOffset, (float)vOffset, uWidth, vHeight, textureWidth, textureHeight);
    }

    public static void blitSprite(class_332 guiGraphics, class_2960 texture, int x, int y) {
        OverlayHelpers.blitSprite(guiGraphics, texture, x, y, 16);
    }

    public static void blitSprite(class_332 guiGraphics, class_2960 texture, int x, int y, int size) {
        OverlayHelpers.blit(guiGraphics, texture, x, y, 0, 0, size, size, size, size);
    }

    public static void checkKeybind() {
        if (ModClient.overlayToggle.method_1434()) {
            if (!hasBeenToggled) {
                ModConfig.get().enabled = !ModConfig.get().enabled;
                hasBeenToggled = true;
            }
        } else {
            hasBeenToggled = false;
        }
    }
}

