/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.immersiveoverlays.neoforge;

import cc.cassian.immersiveoverlays.ModClient;
import cc.cassian.immersiveoverlays.config.neoforge.ModConfigFactory;
import cc.cassian.immersiveoverlays.helpers.ModHelpers;
import cc.cassian.immersiveoverlays.helpers.ModLists;
import cc.cassian.immersiveoverlays.overlay.OverlayHelpers;
import cc.cassian.immersiveoverlays.overlay.OverlayLayer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;

public class ImmersiveOverlaysNeoForgeClient {
    public static final OverlayLayer LAYER = new OverlayLayer();

    public static void init(IEventBus eventBus, ModContainer modContainer) {
        ModClient.init();
        ImmersiveOverlaysNeoForgeClient.registerModsPage();
        NeoForge.EVENT_BUS.addListener(ImmersiveOverlaysNeoForgeClient::checkInventoryForOverlays);
        eventBus.addListener(ImmersiveOverlaysNeoForgeClient::renderGameOverlayEvent);
        eventBus.addListener(ImmersiveOverlaysNeoForgeClient::loadComplete);
    }

    @SubscribeEvent
    public static void loadComplete(FMLClientSetupEvent event) {
        ModLists.loadLists();
    }

    @SubscribeEvent
    public static void renderGameOverlayEvent(RegisterGuiLayersEvent event) {
        event.registerAboveAll(ResourceLocation.fromNamespaceAndPath((String)"immersiveoverlays", (String)"overlay"), (LayeredDraw.Layer)LAYER);
    }

    @SubscribeEvent
    public static void checkInventoryForOverlays(ClientTickEvent.Post event) {
        OverlayHelpers.checkInventoryForOverlays(Minecraft.getInstance());
    }

    public static void registerModsPage() {
        if (ModHelpers.clothConfigInstalled()) {
            ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, ModConfigFactory::new);
        }
    }
}

