/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.immersiveoverlays.mixin;

import cc.cassian.immersiveoverlays.config.ModConfig;
import cc.cassian.immersiveoverlays.overlay.OverlayHelpers;
import folk.sisby.antique_atlas.AntiqueAtlas;
import java.util.List;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Pseudo
@Mixin(value={AntiqueAtlas.class})
public abstract class AntiqueAtlasMixin {
    @Inject(method={"hasHandheldAtlas"}, at={@At(value="RETURN")}, cancellable=true)
    private static void allowMapInBundles(Player player, CallbackInfoReturnable<Boolean> cir) {
        if (ModConfig.get().compat_antique_atlas && ModConfig.get().search_containers) {
            Inventory inventory = player.m_150109_();
            for (ItemStack stack : inventory.f_35974_) {
                if (AntiqueAtlas.isHandheldAtlas((ItemStack)stack)) {
                    cir.setReturnValue((Object)true);
                    continue;
                }
                if (!OverlayHelpers.isContainer(stack)) continue;
                List<ItemStack> contents = OverlayHelpers.getContainerContents(stack).toList();
                for (ItemStack content : contents) {
                    if (!AntiqueAtlas.isHandheldAtlas((ItemStack)content)) continue;
                    cir.setReturnValue((Object)true);
                }
            }
        }
    }
}

