/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.immersiveoverlays.overlay;

import cc.cassian.immersiveoverlays.ModClient;
import cc.cassian.immersiveoverlays.compat.EclipticSeasonsCompat;
import cc.cassian.immersiveoverlays.compat.ModCompat;
import cc.cassian.immersiveoverlays.compat.SereneSeasonsCompat;
import cc.cassian.immersiveoverlays.compat.TerrafirmacraftCompat;
import cc.cassian.immersiveoverlays.config.ModConfig;
import cc.cassian.immersiveoverlays.helpers.TextHelpers;
import cc.cassian.immersiveoverlays.overlay.OverlayHelpers;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import org.apache.commons.lang3.text.WordUtils;

public class ClockOverlay {
    public static boolean showTime = false;
    public static boolean showWeather = false;
    public static boolean showSeason = false;

    public static void renderGameOverlayEvent(GuiGraphics guiGraphics) {
        int yPlacement;
        if (!showWeather && !showTime && !ClockOverlay.shouldShowSeasons() || !ModConfig.get().clock_enable) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (OverlayHelpers.shouldCancelRender(mc)) {
            return;
        }
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        Object time = "Hi! ";
        if (showTime && ((String)(time = mc.f_91073_.m_6042_().f_63858_() ? ClockOverlay.getTime(mc.f_91073_.m_46468_()) : "????")).length() == 4) {
            time = " " + (String)time;
        }
        int xOffset = 3;
        int iconXOffset = 0;
        int tooltipSize = 16;
        int iconYPlacement = yPlacement = ModConfig.get().clock_vertical_position;
        int textYPlacement = yPlacement;
        if (showWeather) {
            if (showTime) {
                iconXOffset = 20;
            }
            tooltipSize = 21;
            textYPlacement += 2;
        }
        if (ClockOverlay.shouldShowSeasons()) {
            if (showTime) {
                tooltipSize = 36;
            } else {
                tooltipSize = 21;
                textYPlacement += 2;
            }
            iconXOffset = 20;
        }
        int fontWidth = mc.f_91062_.m_92895_((String)time) + iconXOffset;
        MutableComponent seasonText = null;
        String seasonString = null;
        if (ClockOverlay.shouldShowSeasons()) {
            seasonString = ClockOverlay.getSeason(mc.f_91073_, mc.f_91074_.m_20183_());
            seasonText = TextHelpers.translatableWithFallback("gui.c.season." + seasonString, WordUtils.capitalizeFully((String)seasonString.replace("_", " ")));
            fontWidth = Integer.max(mc.f_91062_.m_92895_((String)time), mc.f_91062_.m_92852_((FormattedText)seasonText)) + iconXOffset;
        }
        if (OverlayHelpers.playerHasPotions((Player)mc.f_91074_, ModConfig.get().biome_horizontal_position_left)) {
            iconYPlacement += OverlayHelpers.moveBy((Player)mc.f_91074_);
            textYPlacement += OverlayHelpers.moveBy((Player)mc.f_91074_);
        }
        int windowWidth = mc.m_91268_().m_85445_();
        int xPlacement = OverlayHelpers.getPlacement(windowWidth, fontWidth, ModConfig.get().clock_horizontal_position_left);
        OverlayHelpers.renderBackground(guiGraphics, windowWidth, fontWidth, xPlacement, xOffset, yPlacement, tooltipSize, ModConfig.get().clock_horizontal_position_left);
        if (showTime) {
            OverlayHelpers.drawString(guiGraphics, mc.f_91062_, (String)time, xPlacement - xOffset + iconXOffset, textYPlacement, (Integer)ModConfig.get().clock_text_colour);
        }
        if (showWeather) {
            int spriteOffset = ClockOverlay.getWeather((Player)mc.f_91074_);
            OverlayHelpers.blit(guiGraphics, xPlacement - xOffset - 1, iconYPlacement - 1, spriteOffset, 95, 16, 16, 256, 256);
        }
        if (ClockOverlay.shouldShowSeasons()) {
            int seasonTextYPlacement = textYPlacement;
            if (showTime) {
                seasonTextYPlacement += 15;
            }
            OverlayHelpers.drawString(guiGraphics, mc.f_91062_, (Component)seasonText, xPlacement - xOffset + iconXOffset, seasonTextYPlacement, (Integer)ModConfig.get().clock_text_colour);
            assert (seasonString != null);
            ResourceLocation sprite = ClockOverlay.getSprite(seasonString.toLowerCase(Locale.ROOT));
            OverlayHelpers.blitSprite(guiGraphics, sprite, xPlacement - xOffset - 1, seasonTextYPlacement - 4);
        }
    }

    public static ResourceLocation getSprite(String season) {
        String spriteText = season.replace("early_", "").replace("mid_", "").replace("mid_", "").replace("autumn", "fall");
        return ModClient.locate("textures/gui/" + spriteText + ".png");
    }

    public static int getWeather(Player player) {
        Level level = player.m_9236_();
        Biome biome = (Biome)level.m_204166_(player.m_20183_()).m_203334_();
        long time = level.m_46468_() % 24000L;
        Biome.Precipitation precipitation = biome.m_264600_(player.m_20183_());
        boolean snows = biome.m_198904_(player.m_20183_());
        if (!level.m_6042_().f_63858_()) {
            return 124;
        }
        if (level.m_46470_()) {
            if (snows) {
                return 92;
            }
            if (precipitation.equals((Object)Biome.Precipitation.NONE)) {
                return 108;
            }
            return 76;
        }
        if (level.m_46471_()) {
            if (snows) {
                return 92;
            }
            if (precipitation.equals((Object)Biome.Precipitation.NONE)) {
                return 108;
            }
            return 60;
        }
        if (time >= 12500L && time <= 13500L) {
            return 30;
        }
        if (time >= 13500L && time <= 22500L) {
            return 46;
        }
        if (time >= 23000L || time <= 300L) {
            return 15;
        }
        return 0;
    }

    public static String getTime(float dayTime) {
        StringBuilder currentTime = new StringBuilder();
        if (ModConfig.get().clock_day_count) {
            int day = (int)(dayTime / 24000.0f);
            currentTime.append(I18n.m_118938_((String)"gui.c.day", (Object[])new Object[]{day}));
            if (ModConfig.get().clock_current_time) {
                currentTime.append(", ");
            }
        }
        if (ModConfig.get().clock_current_time) {
            int time = (int)(dayTime + 6000.0f) % 24000;
            int m = (int)((float)time % 1000.0f / 1000.0f * 60.0f);
            int hour = time / 1000;
            String a = "";
            if (!Boolean.valueOf(ModConfig.get().clock_24_hour).booleanValue()) {
                String string = a = time < 12000 ? " AM" : " PM";
                if ((hour %= 12) == 0) {
                    hour = 12;
                }
            }
            currentTime.append(hour).append(":").append(m < 10 ? "0" : "").append(m).append(a);
        }
        return currentTime.toString();
    }

    public static boolean shouldShowSeasons() {
        if (ModConfig.get().clock_seasons && showSeason) {
            return ModCompat.SERENE_SEASONS || ModCompat.SIMPLE_SEASONS || ModCompat.FABRIC_SEASONS || ModCompat.TERRAFIRMACRAFT || ModCompat.ECLIPTIC_SEASONS;
        }
        return false;
    }

    public static String getSeason(ClientLevel level, BlockPos pos) {
        String season = "unknown";
        if (ModConfig.get().clock_seasons && showSeason) {
            String eclipticCompat;
            String tfcCompat;
            if (ModCompat.SERENE_SEASONS && ModConfig.get().compat_serene_seasons) {
                season = SereneSeasonsCompat.getSeason(level, pos);
            }
            if (ModCompat.TERRAFIRMACRAFT && ModConfig.get().compat_tfc_seasons && (tfcCompat = TerrafirmacraftCompat.getSeason(level)) != null) {
                season = tfcCompat;
            }
            if (ModCompat.ECLIPTIC_SEASONS && ModConfig.get().compat_ecliptic_seasons && (eclipticCompat = EclipticSeasonsCompat.getSeason(level, pos)) != null) {
                season = eclipticCompat;
            }
        }
        return season;
    }
}

