/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.immersiveoverlays.overlay;

import cc.cassian.immersiveoverlays.ModClient;
import cc.cassian.immersiveoverlays.config.ModConfig;
import cc.cassian.immersiveoverlays.overlay.ClockOverlay;
import cc.cassian.immersiveoverlays.overlay.OverlayHelpers;
import cc.cassian.immersiveoverlays.overlay.TemperatureOverlay;
import java.util.Objects;
import net.minecraft.class_1074;
import net.minecraft.class_1657;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import org.apache.commons.lang3.text.WordUtils;

public class BiomeOverlay {
    public static boolean showBiome = false;
    public static class_2960 UNDEFINED = ModClient.locate("textures/immersiveoverlays/undefined.png");

    public static void renderGameOverlayEvent(class_332 guiGraphics) {
        if (!showBiome || !ModConfig.get().biome_enable) {
            return;
        }
        if (ModConfig.get().biome_reduced_info) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (OverlayHelpers.shouldCancelRender(mc)) {
            return;
        }
        if (mc.field_1724 == null) {
            return;
        }
        class_6880<class_1959> biome = BiomeOverlay.getBiome(mc.field_1724);
        class_2960 biomeId = BiomeOverlay.getId(biome);
        String biomeText = BiomeOverlay.formatBiome(biomeId);
        int yPlacement = ModConfig.get().biome_vertical_position;
        int textYPlacement = yPlacement + 2;
        int xOffset = 3;
        int iconXOffset = 0;
        class_2960 sprite = UNDEFINED;
        if (ModConfig.get().biome_icons && !(sprite = BiomeOverlay.getBiomeSprite(biomeId, true)).equals((Object)UNDEFINED)) {
            iconXOffset = 20;
        }
        int tooltipSize = 21;
        int fontWidth = mc.field_1772.method_1727(biomeText) + iconXOffset;
        if (ModConfig.get().avoid_overlapping) {
            if (!ClockOverlay.showTime && !ClockOverlay.showWeather || !ModConfig.get().clock_enable) {
                yPlacement -= 24;
                textYPlacement -= 24;
            }
            if (ClockOverlay.shouldShowSeasons()) {
                yPlacement += 15;
                textYPlacement += 15;
            }
        }
        if (OverlayHelpers.playerHasPotions((class_1657)mc.field_1724, ModConfig.get().biome_horizontal_position_left)) {
            yPlacement += OverlayHelpers.moveBy((class_1657)mc.field_1724);
            textYPlacement += OverlayHelpers.moveBy((class_1657)mc.field_1724);
        }
        int windowWidth = mc.method_22683().method_4486();
        int xPlacement = OverlayHelpers.getPlacement(windowWidth, fontWidth, ModConfig.get().biome_horizontal_position_left);
        if (showBiome) {
            OverlayHelpers.renderBackground(guiGraphics, windowWidth, fontWidth, xPlacement, xOffset, yPlacement, tooltipSize, ModConfig.get().biome_horizontal_position_left);
            OverlayHelpers.drawString(guiGraphics, mc.field_1772, biomeText, xPlacement - xOffset + iconXOffset, textYPlacement, BiomeOverlay.getTextColour(biome));
            if (ModConfig.get().biome_icons && !sprite.equals((Object)UNDEFINED)) {
                OverlayHelpers.blitSprite(guiGraphics, sprite, xPlacement - xOffset - 1, textYPlacement - 4);
            }
        }
    }

    private static Integer getTextColour(class_6880<class_1959> biome) {
        if (ModConfig.get().biome_text_tinted) {
            return TemperatureOverlay.getBiomeTemperature(biome).color();
        }
        return ModConfig.get().biome_text_colour;
    }

    public static class_2960 getBiomeSprite(class_2960 biome, boolean allowRedirect) {
        class_3300 manager = class_310.method_1551().method_1478();
        String path = "textures/immersiveoverlays/" + biome.method_12832();
        class_2960 key = ModClient.locate(biome.method_12836(), "%s.png".formatted(path));
        class_2960 redirect = ModClient.locate(biome.method_12836(), "%s.txt".formatted(path));
        if (manager.method_14486(key).isPresent()) {
            return key;
        }
        if (manager.method_14486(redirect).isPresent() && allowRedirect) {
            try {
                return BiomeOverlay.getBiomeSprite(Objects.requireNonNull(class_2960.method_12829((String)manager.openAsReader(redirect).lines().toList().get(0))), false);
            }
            catch (Exception e) {
                return UNDEFINED;
            }
        }
        return UNDEFINED;
    }

    public static class_6880<class_1959> getBiome(class_746 player) {
        return player.method_37908().method_23753(player.method_24515());
    }

    public static class_2960 getId(class_6880<class_1959> biome) {
        return biome.method_40230().orElse(class_1972.field_9473).method_29177();
    }

    public static String formatBiome(class_2960 biome) {
        String path = biome.method_12832();
        String namespace = biome.method_12836();
        String key = "biome.%s.%s".formatted(namespace, path);
        if (class_1074.method_4663((String)key)) {
            return class_1074.method_4662((String)key, (Object[])new Object[0]);
        }
        return WordUtils.capitalize((String)path.replace("_", " "));
    }
}

