/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.immersiveoverlays.overlay;

import cc.cassian.immersiveoverlays.config.ModConfig;
import cc.cassian.immersiveoverlays.helpers.ModHelpers;
import cc.cassian.immersiveoverlays.overlay.BiomeOverlay;
import cc.cassian.immersiveoverlays.overlay.ClockOverlay;
import cc.cassian.immersiveoverlays.overlay.OverlayHelpers;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.StringUtils;

public class CompassOverlay {
    public static boolean showX = false;
    public static boolean showY = false;
    public static boolean showZ = false;

    public static void renderGameOverlayEvent(GuiGraphics guiGraphics) {
        boolean showBiomeIcon;
        boolean bl = showBiomeIcon = ModConfig.get().biome_enable && BiomeOverlay.showBiome && ModConfig.get().biome_reduced_info && ModConfig.get().biome_icons;
        if (!(showX || showY || showZ)) {
            return;
        }
        if (!ModConfig.get().compass_enable) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (OverlayHelpers.shouldCancelRender(mc)) {
            return;
        }
        ArrayList<String> coords = new ArrayList<String>();
        if (mc.f_91074_ == null) {
            return;
        }
        BlockPos pos = mc.f_91074_.m_20183_();
        String x = String.format("%d", pos.m_123341_());
        String y = String.format("%d", pos.m_123342_());
        String z = String.format("%d", pos.m_123343_());
        int width = Integer.max(x.length(), z.length());
        width = Integer.max(width, y.length());
        if (showX) {
            x = StringUtils.leftPad((String)x, (int)width);
            coords.add("\u00a7%sX:\u00a7r %s".formatted(Character.valueOf(ModHelpers.getColour(ModConfig.get().compass_x_colour)), x));
        }
        if (showY) {
            y = StringUtils.leftPad((String)y, (int)width);
            coords.add("\u00a7%sY:\u00a7r %s".formatted(Character.valueOf(ModHelpers.getColour(ModConfig.get().compass_y_colour)), y));
        }
        if (showZ) {
            z = StringUtils.leftPad((String)z, (int)width);
            coords.add("\u00a7%sZ:\u00a7r %s".formatted(Character.valueOf(ModHelpers.getColour(ModConfig.get().compass_z_colour)), z));
        }
        int xOffset = 3;
        int yPlacement = ModConfig.get().compass_vertical_position;
        int iconXOffset = 0;
        int iconYOffset = 0;
        if (showBiomeIcon) {
            iconXOffset += 20;
        }
        int fontWidth = mc.f_91062_.m_92895_(StringUtils.repeat((String)"a", (int)(width + 2))) + iconXOffset;
        if (ModConfig.get().avoid_overlapping) {
            if (!ClockOverlay.showTime && !ClockOverlay.showWeather || !ModConfig.get().clock_enable || ModConfig.get().clock_horizontal_position_left != ModConfig.get().compass_horizontal_position_left) {
                yPlacement -= 15;
            }
            if (ClockOverlay.showWeather && ModConfig.get().clock_horizontal_position_left == ModConfig.get().compass_horizontal_position_left) {
                yPlacement += 9;
            }
            if (!BiomeOverlay.showBiome || !ModConfig.get().biome_enable || ModConfig.get().biome_reduced_info || ModConfig.get().biome_horizontal_position_left != ModConfig.get().compass_horizontal_position_left) {
                yPlacement -= 20;
            }
            if (!ClockOverlay.shouldShowSeasons()) {
                yPlacement -= 15;
            }
        }
        if (OverlayHelpers.playerHasPotions((Player)mc.f_91074_, ModConfig.get().compass_horizontal_position_left)) {
            yPlacement += OverlayHelpers.moveBy((Player)mc.f_91074_);
        }
        int tooltipSize = 16;
        if (coords.size() == 2 || coords.size() == 1 && showBiomeIcon) {
            tooltipSize = 25;
            iconYOffset = 3;
        } else if (coords.size() == 3) {
            tooltipSize = 35;
            iconYOffset = 5;
        }
        int windowWidth = mc.m_91268_().m_85445_();
        int xPlacement = OverlayHelpers.getPlacement(windowWidth, fontWidth, ModConfig.get().compass_horizontal_position_left);
        OverlayHelpers.renderBackground(guiGraphics, windowWidth, fontWidth, xPlacement, xOffset, yPlacement, tooltipSize, ModConfig.get().compass_horizontal_position_left);
        if (showBiomeIcon) {
            ResourceLocation sprite = BiomeOverlay.getBiomeSprite(BiomeOverlay.getId(BiomeOverlay.getBiome(mc.f_91074_)), true);
            OverlayHelpers.blit(guiGraphics, sprite, xPlacement - xOffset - 1, yPlacement + iconYOffset, 0, 0, 16, 16, 16, 16);
            xOffset -= 16;
        }
        for (String text : coords) {
            OverlayHelpers.drawString(guiGraphics, mc.f_91062_, text, xPlacement - xOffset, yPlacement, (Integer)ModConfig.get().compass_text_colour);
            Objects.requireNonNull(mc.f_91062_);
            yPlacement += 9;
        }
    }
}

