/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.immersiveoverlays.overlay;

import cc.cassian.immersiveoverlays.compat.FabricSeasonsCompat;
import cc.cassian.immersiveoverlays.compat.SereneSeasonsCompat;
import cc.cassian.immersiveoverlays.compat.SimpleSeasonsCompat;
import cc.cassian.immersiveoverlays.config.ModConfig;
import cc.cassian.immersiveoverlays.helpers.ModHelpers;
import cc.cassian.immersiveoverlays.overlay.OverlayHelpers;
import java.util.Locale;
import net.minecraft.class_1074;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import org.apache.commons.lang3.text.WordUtils;

public class ClockOverlay {
    public static boolean showTime = false;
    public static boolean showWeather = false;
    public static boolean showSeason = false;

    public static void renderGameOverlayEvent(class_4587 guiGraphics) {
        int iconYPlacement;
        if (!showWeather && !showTime && !ClockOverlay.shouldShowSeasons() || !ModConfig.get().clock_enable) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (OverlayHelpers.shouldCancelRender(mc)) {
            return;
        }
        if (mc.field_1687 == null) {
            return;
        }
        Object time = "Hi! ";
        if (showTime && ((String)(time = mc.field_1687.method_8597().comp_645() ? ClockOverlay.getTime(mc.field_1687.method_8532()) : "????")).length() == 4) {
            time = " " + (String)time;
        }
        int xOffset = 3;
        int iconXOffset = 0;
        int tooltipSize = 16;
        int textYPlacement = iconYPlacement = ModConfig.get().clock_vertical_position;
        if (showWeather) {
            if (showTime) {
                iconXOffset = 20;
            }
            tooltipSize = 21;
            textYPlacement += 2;
        }
        if (ClockOverlay.shouldShowSeasons()) {
            if (showTime) {
                textYPlacement = iconYPlacement + 5;
                iconYPlacement += 6;
                tooltipSize = 36;
                textYPlacement += 4;
            } else {
                tooltipSize = 21;
                textYPlacement += 2;
            }
            iconXOffset = 20;
        }
        String seasonText = ClockOverlay.getSeason(mc.field_1687);
        int fontWidth = Integer.max(mc.field_1772.method_1727((String)time), mc.field_1772.method_1727(seasonText)) + iconXOffset;
        if (mc.field_1724 == null) {
            return;
        }
        if (OverlayHelpers.playerHasPotions((class_1657)mc.field_1724, ModConfig.get().biome_horizontal_position_left)) {
            iconYPlacement += OverlayHelpers.moveBy((class_1657)mc.field_1724);
            textYPlacement += OverlayHelpers.moveBy((class_1657)mc.field_1724);
        }
        int windowWidth = mc.method_22683().method_4486();
        int xPlacement = OverlayHelpers.getPlacement(windowWidth, fontWidth, ModConfig.get().clock_horizontal_position_left);
        OverlayHelpers.renderBackground(guiGraphics, windowWidth, fontWidth, xPlacement, xOffset, iconYPlacement, tooltipSize, ModConfig.get().clock_horizontal_position_left);
        if (showTime) {
            OverlayHelpers.drawString(guiGraphics, mc.field_1772, (String)time, xPlacement - xOffset + iconXOffset, textYPlacement, (Integer)0xE0E0E0);
        }
        if (showWeather) {
            int spriteOffset = ClockOverlay.getWeather((class_1657)mc.field_1724);
            OverlayHelpers.blit(guiGraphics, xPlacement - xOffset - 1, iconYPlacement - 1, spriteOffset, 95, 16, 16, 256, 256);
        }
        if (ClockOverlay.shouldShowSeasons()) {
            int seasonTextYPlacement = textYPlacement;
            if (showTime) {
                seasonTextYPlacement += 15;
            }
            OverlayHelpers.drawString(guiGraphics, mc.field_1772, seasonText, xPlacement - xOffset + iconXOffset, seasonTextYPlacement, (Integer)0xE0E0E0);
            int spriteOffset = ClockOverlay.getSprite(seasonText.toLowerCase(Locale.ROOT));
            OverlayHelpers.blit(guiGraphics, xPlacement - xOffset - 1, seasonTextYPlacement - 3, spriteOffset, 207, 16, 14, 256, 256);
        }
    }

    public static int getSprite(String season) {
        return switch (season) {
            case "spring" -> 112;
            case "summer" -> 128;
            case "fall" -> 144;
            case "winter" -> 160;
            default -> 0;
        };
    }

    public static int getWeather(class_1657 player) {
        class_1937 level = player.field_6002;
        class_1959 biome = (class_1959)level.method_23753(player.method_24515()).comp_349();
        long time = level.method_8532() % 24000L;
        class_1959.class_1963 precipitation = biome.method_8694();
        boolean snows = biome.method_33599(player.method_24515());
        if (!level.method_8597().comp_645()) {
            return 124;
        }
        if (level.method_8546()) {
            if (snows) {
                return 92;
            }
            if (precipitation.equals((Object)class_1959.class_1963.field_9384)) {
                return 108;
            }
            return 76;
        }
        if (level.method_8419()) {
            if (snows) {
                return 92;
            }
            if (precipitation.equals((Object)class_1959.class_1963.field_9384)) {
                return 108;
            }
            return 60;
        }
        if (time >= 12500L && time <= 13500L) {
            return 30;
        }
        if (time >= 13500L && time <= 22500L) {
            return 46;
        }
        if (time >= 23000L || time <= 300L) {
            return 15;
        }
        return 0;
    }

    public static String getTime(float dayTime) {
        StringBuilder currentTime = new StringBuilder();
        if (ModConfig.get().clock_day_count) {
            int day = (int)(dayTime / 24000.0f);
            currentTime.append(class_1074.method_4662((String)"gui.c.day", (Object[])new Object[]{day}));
            if (ModConfig.get().clock_current_time) {
                currentTime.append(", ");
            }
        }
        if (ModConfig.get().clock_current_time) {
            int time = (int)(dayTime + 6000.0f) % 24000;
            int m = (int)((float)time % 1000.0f / 1000.0f * 60.0f);
            int hour = time / 1000;
            String a = "";
            if (!Boolean.valueOf(ModConfig.get().clock_24_hour).booleanValue()) {
                String string = a = time < 12000 ? " AM" : " PM";
                if ((hour %= 12) == 0) {
                    hour = 12;
                }
            }
            currentTime.append(hour).append(":").append(m < 10 ? "0" : "").append(m).append(a);
        }
        return currentTime.toString();
    }

    public static boolean shouldShowSeasons() {
        if (ModConfig.get().compat_seasons && showSeason) {
            return ModHelpers.isLoaded("sereneseasons") || ModHelpers.isLoaded("simple-seasons") || ModHelpers.isLoaded("seasons");
        }
        return false;
    }

    public static String getSeason(class_638 level) {
        String season = "";
        if (ModConfig.get().compat_seasons && showSeason) {
            if (ModHelpers.isLoaded("seasons")) {
                season = FabricSeasonsCompat.getSeason(level);
            } else if (ModHelpers.isLoaded("sereneseasons")) {
                season = SereneSeasonsCompat.getSeason(level);
            } else if (ModHelpers.isLoaded("simple-seasons")) {
                season = SimpleSeasonsCompat.getSeason(level);
            }
        }
        return WordUtils.capitalizeFully((String)season);
    }
}

