/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.immersiveoverlays.overlay;

import cc.cassian.immersiveoverlays.ModClient;
import cc.cassian.immersiveoverlays.config.ModConfig;
import cc.cassian.immersiveoverlays.overlay.ClockOverlay;
import cc.cassian.immersiveoverlays.overlay.OverlayHelpers;
import cc.cassian.immersiveoverlays.overlay.TemperatureOverlay;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import org.apache.commons.lang3.text.WordUtils;

public class BiomeOverlay {
    public static boolean showBiome = false;
    public static ResourceLocation UNDEFINED = ModClient.locate("textures/immersiveoverlays/undefined.png");

    public static void renderGameOverlayEvent(GuiGraphics guiGraphics) {
        if (!showBiome || !ModConfig.get().biome_enable) {
            return;
        }
        if (ModConfig.get().biome_reduced_info) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (OverlayHelpers.shouldCancelRender(mc)) {
            return;
        }
        if (mc.player == null) {
            return;
        }
        Holder<Biome> biome = BiomeOverlay.getBiome(mc.player);
        ResourceLocation biomeId = BiomeOverlay.getId(biome);
        String biomeText = BiomeOverlay.formatBiome(biomeId);
        int yPlacement = ModConfig.get().biome_vertical_position;
        int textYPlacement = yPlacement + 2;
        int xOffset = 3;
        int iconXOffset = 0;
        ResourceLocation sprite = UNDEFINED;
        if (ModConfig.get().biome_icons && !(sprite = BiomeOverlay.getBiomeSprite(biomeId, true)).equals((Object)UNDEFINED)) {
            iconXOffset = 20;
        }
        int tooltipSize = 21;
        int fontWidth = mc.font.width(biomeText) + iconXOffset;
        if (ModConfig.get().avoid_overlapping) {
            if (!ClockOverlay.showTime && !ClockOverlay.showWeather || !ModConfig.get().clock_enable) {
                yPlacement -= 24;
                textYPlacement -= 24;
            }
            if (ClockOverlay.shouldShowSeasons()) {
                yPlacement += 15;
                textYPlacement += 15;
            }
        }
        if (OverlayHelpers.playerHasPotions((Player)mc.player, ModConfig.get().biome_horizontal_position_left)) {
            yPlacement += OverlayHelpers.moveBy((Player)mc.player);
            textYPlacement += OverlayHelpers.moveBy((Player)mc.player);
        }
        int windowWidth = mc.getWindow().getGuiScaledWidth();
        int xPlacement = OverlayHelpers.getPlacement(windowWidth, fontWidth, ModConfig.get().biome_horizontal_position_left);
        if (showBiome) {
            OverlayHelpers.renderBackground(guiGraphics, windowWidth, fontWidth, xPlacement, xOffset, yPlacement, tooltipSize, ModConfig.get().biome_horizontal_position_left);
            OverlayHelpers.drawString(guiGraphics, mc.font, biomeText, xPlacement - xOffset + iconXOffset, textYPlacement, BiomeOverlay.getTextColour(biome));
            if (ModConfig.get().biome_icons && !sprite.equals((Object)UNDEFINED)) {
                OverlayHelpers.blitSprite(guiGraphics, sprite, xPlacement - xOffset - 1, textYPlacement - 4);
            }
        }
    }

    private static Integer getTextColour(Holder<Biome> biome) {
        if (ModConfig.get().biome_text_tinted) {
            return TemperatureOverlay.getBiomeTemperature(biome).color();
        }
        return ModConfig.get().biome_text_colour;
    }

    public static ResourceLocation getBiomeSprite(ResourceLocation biome, boolean allowRedirect) {
        ResourceManager manager = Minecraft.getInstance().getResourceManager();
        String path = "textures/immersiveoverlays/" + biome.getPath();
        ResourceLocation key = ModClient.locate(biome.getNamespace(), "%s.png".formatted(path));
        ResourceLocation redirect = ModClient.locate(biome.getNamespace(), "%s.txt".formatted(path));
        if (manager.getResource(key).isPresent()) {
            return key;
        }
        if (manager.getResource(redirect).isPresent() && allowRedirect) {
            try {
                return BiomeOverlay.getBiomeSprite(Objects.requireNonNull(ResourceLocation.tryParse((String)manager.openAsReader(redirect).lines().toList().get(0))), false);
            }
            catch (Exception e) {
                return UNDEFINED;
            }
        }
        return UNDEFINED;
    }

    public static Holder<Biome> getBiome(LocalPlayer player) {
        return player.level().getBiome(player.blockPosition());
    }

    public static ResourceLocation getId(Holder<Biome> biome) {
        return biome.unwrapKey().orElse(Biomes.THE_VOID).location();
    }

    public static String formatBiome(ResourceLocation biome) {
        String path = biome.getPath();
        String namespace = biome.getNamespace();
        String key = "biome.%s.%s".formatted(namespace, path);
        if (I18n.exists((String)key)) {
            return I18n.get((String)key, (Object[])new Object[0]);
        }
        return WordUtils.capitalize((String)path.replace("_", " "));
    }
}

