package cc.cassian.immersiveoverlays.overlay;

import cc.cassian.immersiveoverlays.ModClient;
import cc.cassian.immersiveoverlays.compat.*;
import cc.cassian.immersiveoverlays.config.ModConfig;
import org.apache.commons.lang3.text.WordUtils;

import java.util.Locale;
import net.minecraft.class_1074;
import net.minecraft.class_1657;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_638;

public class ClockOverlay {
    public static boolean showTime = false;
    public static boolean showWeather = false;
    public static boolean showSeason = false;


    //? if >1.20 {
    public static void renderGameOverlayEvent(class_332 guiGraphics) {
    //?} else {
        /*public static void renderGameOverlayEvent(PoseStack guiGraphics) {
     *///?}
        if ((!showWeather && !showTime && !shouldShowSeasons()) || !ModConfig.get().clock_enable)
            return;
        var mc = class_310.method_1551();
        if (OverlayHelpers.shouldCancelRender(mc))
            return;
        if (mc.field_1687 == null || mc.field_1724 == null) return;

        String time = "Hi! ";
        if (showTime) {
            if (mc.field_1687.method_8597().comp_645()) {
                time = getTime(mc.field_1687.method_8532());
            } else {
                time = "????";
            }

            if (time.length() == 4) {
                time = " " + time;
            }
        }

        int xOffset = 3;
        // The amount of offset needed to display the barometer icons, if visible.
        int iconXOffset = 0;
        int tooltipSize = 16;
        int yPlacement = ModConfig.get().clock_vertical_position;
        int iconYPlacement = yPlacement;
        int textYPlacement = yPlacement;
        if (showWeather) {
            if (showTime) {
                iconXOffset = 20;
            }
            tooltipSize = 21;
            textYPlacement += 2;
        }
        if (shouldShowSeasons()) {
            if (showTime) {
                textYPlacement = iconYPlacement+5;
                tooltipSize = 36;
            } else {
                tooltipSize = 21;
                textYPlacement += 2;
            }
            iconXOffset = 20;
        }

        var seasonString = ClockOverlay.getSeason(mc.field_1687, mc.field_1724.method_24515());
        //? if >1.20 {
        var seasonText = class_2561.method_48321("gui.c.season."+seasonString, WordUtils.capitalizeFully(seasonString.replace("_", " ")));
        //?} else {
        /*var seasonText = Component.literal(WordUtils.capitalizeFully(seasonString.replace("_", " ")));
        *///?}
        int fontWidth = Integer.max(mc.field_1772.method_1727(time), mc.field_1772.method_27525(seasonText))+iconXOffset;

        if (OverlayHelpers.playerHasPotions(mc.field_1724, ModConfig.get().biome_horizontal_position_left)) {
            iconYPlacement += OverlayHelpers.moveBy(mc.field_1724);
            textYPlacement += OverlayHelpers.moveBy(mc.field_1724);
        }

        int windowWidth = mc.method_22683().method_4486();
        int xPlacement = OverlayHelpers.getPlacement(windowWidth, fontWidth, ModConfig.get().clock_horizontal_position_left);
        OverlayHelpers.renderBackground(guiGraphics, windowWidth, fontWidth, xPlacement, xOffset, yPlacement, tooltipSize, ModConfig.get().clock_horizontal_position_left);
        if (showTime) {
            // render text
            OverlayHelpers.drawString(guiGraphics, mc.field_1772, time, xPlacement-xOffset+iconXOffset, textYPlacement, ModConfig.get().clock_text_colour);
        }
        if (showWeather) {
            var spriteOffset = getWeather(mc.field_1724);
            OverlayHelpers.blit(guiGraphics, xPlacement-xOffset-1, iconYPlacement-1, spriteOffset, 95, 16, 16, OverlayHelpers.textureSize, OverlayHelpers.textureSize);
        }
        if (ClockOverlay.shouldShowSeasons()) {
            int seasonTextYPlacement = textYPlacement;
            int seasonIconYPlacement;
            if (showTime) {
                seasonTextYPlacement+=15;
                seasonIconYPlacement = seasonTextYPlacement-5;
            } else {
                seasonIconYPlacement = seasonTextYPlacement-4;
            }
            OverlayHelpers.drawString(guiGraphics, mc.field_1772, seasonText, xPlacement-xOffset+iconXOffset, seasonTextYPlacement, ModConfig.get().clock_text_colour);
            var sprite = getSprite(seasonString.toLowerCase(Locale.ROOT));
            OverlayHelpers.blitSprite(guiGraphics, sprite, xPlacement-xOffset-1, seasonIconYPlacement);
        }
    }

    public static class_2960 getSprite(String season) {
        var spriteText = season.replace("early_", "").replace("mid_", "").replace("mid_", "").replace("autumn", "fall");
        return ModClient.locate("textures/gui/"+spriteText+".png");
    }

    public static int getWeather(class_1657 player) {
        var level = player.method_37908
        //? if >1.20 {
        ();
        //?} else {
        /*;
        *///?}
        var biome = level.method_23753(player.method_24515()).comp_349();
        var time = level.method_8532() % 24000;
        //? if >1.21.2 {
        var precipitation = biome.method_48162(player.method_24515(), level.method_8615());
        //?} else if >1.20 {
        /*var precipitation = biome.getPrecipitationAt(player.blockPosition());
        *///?} else {
         /*var precipitation = biome.getPrecipitation();
        *///?}
        //? if >1.21.2 {
        var snows = biome.method_33599(player.method_24515(), level.method_8615());
        //?} else {
        /*var snows = biome.coldEnoughToSnow(player.blockPosition());
         *///?}
        if (!level.method_8597().comp_645()) return 124; // Netherlike
        else if (level.method_8546()) {
            if (snows) return 92; // Snowing
            if (precipitation.equals(class_1959.class_1963.field_9384)) return 108; // Sandstorming
            return 76; // Thundering
        } else if (level.method_8419()) {
            if (snows) return 92; // Snowing
            if (precipitation.equals(class_1959.class_1963.field_9384)) return 108; // Sandstorming
            return 60; // Raining
        }
        else if (time >= 12500 && time <= 13500) return 30; // Sunset
        else if (time >= 13500 && time <= 22500) return 46; // Night
        else if (time >= 23000 || time <= 300) return 15; // Morning
        return 0; // Sunny
    }

    // This code was originally authored by MehVadVukaar for Supplementaries.
    // It is adapted here for our clock overlay as authorized by the
    // Supplementaries Team License, as Immersive Overlays is not designed
    // to compete with Supplementaries.
    public static String getTime(float dayTime) {
        StringBuilder currentTime = new StringBuilder();
        if (ModConfig.get().clock_day_count) {
            int day = (int) (dayTime/24000);
           currentTime.append(class_1074.method_4662("gui.c.day", day));
           if (ModConfig.get().clock_current_time) {
               currentTime.append(", ");
           }
        }
        if (ModConfig.get().clock_current_time) {
            int time = (int)(dayTime + 6000L) % 24000;
            int m = (int)((float)time % 1000.0F / 1000.0F * 60.0F);
            int hour = time / 1000;
            String a = "";
            if (!(Boolean) ModConfig.get().clock_24_hour) {
                a = time < 12000 ? " AM" : " PM";
                hour %= 12;
                if (hour == 0) {
                    hour = 12;
                }
            }
            currentTime.append(hour).append(":").append(m < 10 ? "0" : "").append(m).append(a);
        }
        return currentTime.toString();
    }

    public static boolean shouldShowSeasons() {
        if (ModConfig.get().clock_seasons && showSeason) {
            return ModCompat.SERENE_SEASONS || ModCompat.SIMPLE_SEASONS || ModCompat.FABRIC_SEASONS || ModCompat.TERRAFIRMACRAFT || ModCompat.ECLIPTIC_SEASONS;
        }
        return false;
    }

    public static String getSeason(class_638 level, class_2338 pos) {
        String season = "unknown";
        if (ModConfig.get().clock_seasons && showSeason) {
            //? if >1.20 {
            if (ModCompat.SERENE_SEASONS && ModConfig.get().compat_serene_seasons) {
                season = SereneSeasonsCompat.getSeason(level, pos);
            }
            //?}
            //? if fabric {
            if (ModCompat.FABRIC_SEASONS && ModConfig.get().compat_fabric_seasons) {
                season = FabricSeasonsCompat.getSeason(level);
            }
            if (ModCompat.SIMPLE_SEASONS && ModConfig.get().compat_simple_seasons) {
                season = SimpleSeasonsCompat.getSeason(level);
            }
            //?}
            //? if forge || neoforge {
            /*if (ModCompat.TERRAFIRMACRAFT && ModConfig.get().compat_tfc_seasons) {
                var tfcCompat = TerrafirmacraftCompat.getSeason(level);
                if (tfcCompat != null) season = tfcCompat;
            }
            *///?}
            //? if forge && >1.20 {
            /* if (ModCompat.ECLIPTIC_SEASONS && ModConfig.get().compat_ecliptic_seasons) {
                var eclipticCompat = EclipticSeasonsCompat.getSeason(level, pos);
                if (eclipticCompat != null) season = eclipticCompat;
            }
            *///?}
        }
        return WordUtils.capitalizeFully(season);
    }
}
