/*
 * Decompiled with CFR 0.152.
 */
package com.github.tatercertified.vanilla.util;

import com.github.tatercertified.vanilla.util.Mapping;
import java.io.IOException;
import org.spongepowered.asm.service.MixinService;

public class LoaderUtil {
    public static final Mapping MAPPINGS = LoaderUtil.getMappings();

    private static Mapping getMappings() {
        if (LoaderUtil.checkForClass("io.papermc.paperclip.Paperclip") || LoaderUtil.checkForClass("org.spigotmc.CustomTimingsHandler")) {
            return Mapping.Mojmap;
        }
        if (LoaderUtil.checkForClass("net.fabricmc.loader.api.FabricLoader") || LoaderUtil.checkForClass("net.quiltservertools.quilt.api.QuiltServer")) {
            return Mapping.Intermediary;
        }
        if (LoaderUtil.checkForClass("net.neoforged.neoforge.common.NeoForge") || LoaderUtil.checkForClass("net.minecraftforge.fml.loading.FMLLoader")) {
            return Mapping.SRG;
        }
        if (LoaderUtil.checkForClass("org.spongepowered.api.Sponge")) {
            return Mapping.Mojmap;
        }
        throw new RuntimeException("Unknown loader detected; Failing to load NoDim");
    }

    private static boolean checkForClass(String className) {
        try {
            MixinService.getService().getBytecodeProvider().getClassNode(className);
        }
        catch (IOException | ClassNotFoundException ignored) {
            return false;
        }
        return true;
    }
}

