/*
 * Decompiled with CFR 0.152.
 */
package com.github.tatercertified.y_intmdry;

import com.github.tatercertified.y_intmdry.annotation.MCVer;
import com.github.tatercertified.y_intmdry.annotation.Map;
import com.github.tatercertified.y_intmdry.util.LoaderUtil;
import com.github.tatercertified.y_intmdry.util.Mapping;
import com.github.tatercertified.y_intmdry.util.MinecraftVersion;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.MixinService;

public class NoDimMixinPlugin
implements IMixinConfigPlugin {
    private int minor;
    private int patch;

    public void onLoad(String s) {
        this.minor = MinecraftVersion.getMinor(MinecraftVersion.getVersion());
        this.patch = MinecraftVersion.getPatch(MinecraftVersion.getVersion());
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String s, String s1) {
        ClassNode mixinClassNode;
        try {
            mixinClassNode = MixinService.getService().getBytecodeProvider().getClassNode(s1);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (mixinClassNode.visibleAnnotations != null) {
            for (AnnotationNode annotation : mixinClassNode.visibleAnnotations) {
                Mapping mapping;
                if (!annotation.desc.equals(Map.class.descriptorString()) || (mapping = Mapping.fromString(((String[])annotation.values.get(1))[1])) == LoaderUtil.MAPPINGS) continue;
                return false;
            }
            for (AnnotationNode annotation : mixinClassNode.visibleAnnotations) {
                String maxVer;
                if (!annotation.desc.equals(MCVer.class.descriptorString())) continue;
                HashMap<String, Object> annotationValues = new HashMap<String, Object>();
                for (int i = 0; i < annotation.values.size(); i += 2) {
                    String k = (String)annotation.values.get(i);
                    Object v = annotation.values.get(i + 1);
                    annotationValues.put(k, v);
                }
                String minVer = annotationValues.getOrDefault("min", MinecraftVersion.getVersion());
                if (MinecraftVersion.isBetween(this.minor, this.patch, minVer, maxVer = annotationValues.getOrDefault("max", MinecraftVersion.getVersion()))) continue;
                return false;
            }
        }
        return true;
    }

    public void acceptTargets(Set<String> set, Set<String> set1) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String s, ClassNode classNode, String s1, IMixinInfo iMixinInfo) {
    }

    public void postApply(String s, ClassNode classNode, String s1, IMixinInfo iMixinInfo) {
    }
}

