/*
 * Decompiled with CFR 0.152.
 */
package com.github.tatercertified.y_intmdry.util;

import com.github.tatercertified.y_intmdry.util.SerializedMCVer;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraft.class_2374;

public final class MinecraftVersion {
    private static String cachedVersion;

    public static String getVersion() {
        if (cachedVersion == null) {
            cachedVersion = MinecraftVersion.getMinecraftVersion();
        }
        return cachedVersion;
    }

    public static boolean isBetween(int inputMinor, int inputPatch, String min, String max) {
        int minPatch;
        int minMinor = MinecraftVersion.getMinor(min);
        if (inputMinor < minMinor) {
            return false;
        }
        int maxMinor = MinecraftVersion.getMinor(max);
        if (inputMinor > maxMinor) {
            return false;
        }
        if (inputMinor == minMinor && inputPatch < (minPatch = MinecraftVersion.getPatch(min))) {
            return false;
        }
        if (inputMinor == maxMinor) {
            int maxPatch = MinecraftVersion.getPatch(max);
            return inputPatch <= maxPatch;
        }
        return true;
    }

    public static int getMinor(String version) {
        String[] split = version.split("\\.");
        return Integer.parseInt(split[1]);
    }

    public static int getPatch(String version) {
        String[] split = version.split("\\.");
        if (split.length == 3) {
            return Integer.parseInt(split[2]);
        }
        return 0;
    }

    private static String getMinecraftVersion() {
        try {
            SerializedMCVer ver;
            try (InputStream inputStream = class_2374.class.getResourceAsStream("/version.json");){
                if (inputStream == null) {
                    throw new RuntimeException("Failed to locate Minecraft Version");
                }
                try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream);){
                    Gson gson = new Gson();
                    ver = (SerializedMCVer)gson.fromJson((Reader)inputStreamReader, SerializedMCVer.class);
                }
            }
            return ver.getId();
        }
        catch (JsonParseException | IOException exception) {
            throw new IllegalStateException("Game version information is corrupt", exception);
        }
    }
}

