/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.pe.debug;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.Queue;
import net.lopymine.pe.ParticleEffects;
import net.lopymine.pe.mixin.ParticleEngineMixin;
import net.lopymine.pe.particle.TexturedParticle;
import net.lopymine.pe.utils.ArgbUtils;
import net.lopymine.pe.utils.PEDebugParticle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

public class DebugParticleInfoRenderer {
    public static void renderAll(PoseStack matrices, Vec3 camera, Quaternionf cameraRotation, float tickProgress) {
        for (Queue<Particle> value : ((ParticleEngineMixin)Minecraft.m_91087_().f_91061_).getParticles().values()) {
            for (Particle particle : value) {
                DebugParticleInfoRenderer.renderDebugInfo(matrices, camera, cameraRotation, tickProgress, particle);
            }
        }
    }

    public static void renderDebugInfo(PoseStack matrices, Vec3 camera, Quaternionf cameraRotation, float tickProgress, Particle particle) {
        if (!ParticleEffects.getConfig().isDebugLogEnabled()) {
            return;
        }
        float x = (float)(Mth.m_14139_((double)tickProgress, (double)particle.f_107209_, (double)particle.f_107212_) - camera.m_7096_());
        float y = (float)(Mth.m_14139_((double)tickProgress, (double)particle.f_107210_, (double)particle.f_107213_) - camera.m_7098_());
        float z = (float)(Mth.m_14139_((double)tickProgress, (double)particle.f_107211_, (double)particle.f_107214_) - camera.m_7094_());
        Font textRenderer = Minecraft.m_91087_().f_91062_;
        matrices.m_85836_();
        matrices.m_85837_((double)x, (double)y + 0.5, (double)z);
        matrices.m_252781_(cameraRotation);
        matrices.m_85841_(-0.015f, -0.015f, 0.015f);
        String[] text = DebugParticleInfoRenderer.getDebugInfo(particle);
        int yOffset = 0;
        for (String line : text) {
            float f = (float)(-textRenderer.m_92895_(line)) / 2.0f;
            textRenderer.m_271703_(line, f, (float)(-yOffset), -1, false, matrices.m_85850_().m_252922_(), (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            Objects.requireNonNull(textRenderer);
            yOffset += 9 + 1;
        }
        matrices.m_85849_();
    }

    private static String @NotNull [] getDebugInfo(Particle particle) {
        int blue;
        int green;
        int red;
        int alpha;
        int color;
        if (particle instanceof TexturedParticle) {
            TexturedParticle texturedParticle = (TexturedParticle)particle;
            color = texturedParticle.getHolderColor();
            alpha = ArgbUtils.getAlpha(color);
            red = ArgbUtils.getRed(color);
            green = ArgbUtils.getGreen(color);
            blue = ArgbUtils.getBlue(color);
        } else {
            alpha = (int)(particle.f_107230_ * 255.0f);
            red = (int)(particle.f_107227_ * 255.0f);
            green = (int)(particle.f_107228_ * 255.0f);
            blue = (int)(particle.f_107229_ * 255.0f);
            color = ArgbUtils.getArgb(alpha, red, green, blue);
        }
        return new String[]{"Original Effect Color", "ARGB: " + color, "A: %s R: %s G: %s B: %s".formatted(alpha, red, green, blue), "Debug Data: " + ((PEDebugParticle)particle).particleEffects$getDebugData()};
    }
}

