/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.pe.modmenu;

import net.lopymine.pe.client.ParticleEffectsClient;
import net.lopymine.pe.loader.MossyLoader;
import net.lopymine.pe.modmenu.NoConfigLibraryScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public abstract class AbstractModMenuIntegration {
    public void register(ModContainer container) {
        container.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((minecraft, parent) -> {
            if (MossyLoader.isModLoaded("yet_another_config_lib_v3", false)) {
                ModContainer yacl = (ModContainer)ModList.get().getModContainerById("yet_another_config_lib_v3").orElseThrow();
                ArtifactVersion version = yacl.getModInfo().getVersion();
                try {
                    DefaultArtifactVersion requestsVersion = new DefaultArtifactVersion("3.6.6+1.20.1-forge");
                    if (version.compareTo((Object)requestsVersion) >= 0) {
                        return this.createConfigScreen((Screen)parent);
                    }
                }
                catch (Exception e) {
                    ParticleEffectsClient.LOGGER.error("Failed to compare YACL version, tell mod author about this error: ", (Throwable)e);
                }
                return NoConfigLibraryScreen.createScreenAboutOldVersion(parent, version.getQualifier());
            }
            return NoConfigLibraryScreen.createScreen(parent);
        }));
    }

    protected abstract String getModId();

    protected abstract Screen createConfigScreen(Screen var1);
}

