/*
 * Decompiled with CFR 0.152.
 */
package com.srnyx.commandlogger;

import com.srnyx.commandlogger.config.ConfigYml;
import com.srnyx.commandlogger.libs.annoyingapi.AnnoyingPlugin;
import com.srnyx.commandlogger.libs.annoyingapi.PluginPlatform;
import com.srnyx.commandlogger.libs.annoyingapi.options.BStatsOptions;
import com.srnyx.commandlogger.libs.annoyingapi.options.PluginOptions;
import com.srnyx.commandlogger.listeners.ConsoleCommandListener;
import com.srnyx.commandlogger.listeners.PlayerCommandListener;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.Date;
import java.util.function.Consumer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class CommandLogger
extends AnnoyingPlugin {
    @NotNull
    public final Path logsFolder = this.getDataFolder().toPath().resolve("logs");
    public ConfigYml config;
    @NotNull
    private final PlayerCommandListener playerCommandListener = new PlayerCommandListener(this);
    @NotNull
    private final ConsoleCommandListener consoleCommandListener = new ConsoleCommandListener(this);

    public CommandLogger() {
        this.options.pluginOptions((Consumer<PluginOptions>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$new$0(com.srnyx.commandlogger.libs.annoyingapi.options.PluginOptions ), (Lcom/srnyx/commandlogger/libs/annoyingapi/options/PluginOptions;)V)((CommandLogger)this)).bStatsOptions((Consumer<BStatsOptions>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$new$1(com.srnyx.commandlogger.libs.annoyingapi.options.BStatsOptions ), (Lcom/srnyx/commandlogger/libs/annoyingapi/options/BStatsOptions;)V)()).registrationOptions.automaticRegistration.packages("com.srnyx.commandlogger.commands");
    }

    @Override
    public void enable() {
        this.reload();
    }

    @Override
    public void reload() {
        this.config = new ConfigYml(this);
        this.playerCommandListener.setRegistered(this.config.players.enabled && (this.config.players.combined.enabled || !this.config.players.splits.isEmpty()));
        this.consoleCommandListener.setRegistered(this.config.console.enabled && (this.config.console.combined.enabled || !this.config.console.splits.isEmpty()));
    }

    @NotNull
    public String processFileNameVariables(@NotNull String string) {
        Date now = new Date();
        return string.replace("{date}", this.config.variableFormats.date.fileNames.format(now)).replace("{time}", this.config.variableFormats.time.fileNames.format(now));
    }

    @NotNull
    public String processFormatVariables(@NotNull String string, @NotNull CommandSender sender, @NotNull String command) {
        String playerName = sender.getName();
        String uuid = "";
        String ip = "";
        if (sender instanceof Player) {
            Player player = (Player)sender;
            InetSocketAddress address = player.getAddress();
            uuid = player.getUniqueId().toString();
            ip = address != null ? address.getAddress().getHostAddress() : "";
        } else {
            playerName = "*" + playerName + "*";
        }
        Date now = new Date();
        return string.replace("{date}", this.config.variableFormats.date.formats.format(now)).replace("{time}", this.config.variableFormats.time.formats.format(now)).replace("{player}", playerName).replace("{uuid}", uuid).replace("{ip}", ip).replace("{command}", command) + "\n";
    }

    @NotNull
    public String processFormatVariables(@NotNull String format, @NotNull ServerCommandEvent event) {
        return this.processFormatVariables(format, event.getSender(), "/" + event.getCommand());
    }

    @NotNull
    public String processFormatVariables(@NotNull String format, @NotNull PlayerCommandPreprocessEvent event) {
        return this.processFormatVariables(format, (CommandSender)event.getPlayer(), event.getMessage());
    }

    private static /* synthetic */ void lambda$new$1(BStatsOptions bStatsOptions) {
        bStatsOptions.id(26170);
    }

    private /* synthetic */ void lambda$new$0(PluginOptions pluginOptions) {
        pluginOptions.updatePlatforms(new PluginPlatform.Multi(PluginPlatform.modrinth("PMWx2eoO"), PluginPlatform.hangar((Plugin)this), PluginPlatform.spigot("126150")));
    }
}

