/*
 * Decompiled with CFR 0.152.
 */
package com.srnyx.commandlogger.config;

import com.srnyx.commandlogger.CommandLogger;
import com.srnyx.commandlogger.config.Split;
import com.srnyx.commandlogger.libs.annoyingapi.AnnoyingPlugin;
import com.srnyx.commandlogger.libs.annoyingapi.file.AnnoyingResource;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigYml {
    @NotNull
    private final CommandLogger plugin;
    @NotNull
    private final AnnoyingResource config;
    public final boolean enabled;
    @NotNull
    public final VariableFormats variableFormats;
    @NotNull
    public final Combined combined;
    @NotNull
    public final Players players;
    @NotNull
    public final Console console;

    public ConfigYml(@NotNull CommandLogger plugin) {
        this.plugin = plugin;
        this.config = new AnnoyingResource((AnnoyingPlugin)plugin, "config.yml");
        this.enabled = this.config.getBoolean("enabled", true);
        this.variableFormats = new VariableFormats();
        this.combined = new Combined();
        this.players = new Players();
        this.console = new Console();
    }

    public class Console {
        public final boolean enabled;
        @NotNull
        public final Combined combined;
        @NotNull
        public final List<Split> splits;

        public Console() {
            this.enabled = ConfigYml.this.config.getBoolean("console.enabled", true);
            this.combined = new Combined();
            this.splits = new ArrayList<Split>();
            for (Map map : ConfigYml.this.config.getMapList("console.splits")) {
                Boolean enabled = (Boolean)map.get("enabled");
                if (enabled == null || !enabled.booleanValue()) continue;
                this.splits.add(new Split(ConfigYml.this.plugin, map, "console/{date}.log", "[{time}] {command}"));
            }
        }

        public class Combined {
            public final boolean enabled;
            @NotNull
            public final Path file;
            @NotNull
            public final String format;

            public Combined() {
                this.enabled = ConfigYml.this.config.getBoolean("console.combined.enabled", true);
                this.file = ((ConfigYml)ConfigYml.this).plugin.logsFolder.resolve(ConfigYml.this.config.getString("console.combined.file", "console.log"));
                this.format = ConfigYml.this.config.getString("console.combined.format", "[{date} {time}] {command}");
            }

            @NotNull
            public String format(@NotNull ServerCommandEvent event) {
                return ConfigYml.this.plugin.processFormatVariables(this.format, event);
            }
        }
    }

    public class Players {
        public final boolean enabled;
        @NotNull
        public final Combined combined;
        @NotNull
        public final List<Split.PlayerSplit> splits;

        public Players() {
            this.enabled = ConfigYml.this.config.getBoolean("players.enabled", true);
            this.combined = new Combined();
            this.splits = new ArrayList<Split.PlayerSplit>();
            for (Map map : ConfigYml.this.config.getMapList("players.splits")) {
                Boolean enabled = (Boolean)map.get("enabled");
                if (enabled == null || !enabled.booleanValue()) continue;
                this.splits.add(new Split.PlayerSplit(ConfigYml.this.plugin, map, "players/{uuid}.log", "[{date} {time}] {command}"));
            }
        }

        public class Combined {
            public final boolean enabled;
            @NotNull
            public final Path file;
            @Nullable
            public final String requiredPermission;
            @NotNull
            public final String format;

            public Combined() {
                this.enabled = ConfigYml.this.config.getBoolean("players.combined.enabled", true);
                this.file = ((ConfigYml)ConfigYml.this).plugin.logsFolder.resolve(ConfigYml.this.config.getString("players.combined.file", "players.log"));
                this.format = ConfigYml.this.config.getString("players.combined.format", "[{date} {time}] [{player}] {command}");
                String requiredPermission = ConfigYml.this.config.getString("players.combined.required-permission");
                this.requiredPermission = requiredPermission != null && requiredPermission.trim().isEmpty() ? null : requiredPermission;
            }

            public boolean hasRequiredPermission(@NotNull Player player) {
                return this.requiredPermission == null || player.hasPermission(this.requiredPermission);
            }

            @NotNull
            public String format(@NotNull PlayerCommandPreprocessEvent event) {
                return ConfigYml.this.plugin.processFormatVariables(this.format, event);
            }
        }
    }

    public class Combined {
        public final boolean enabled;
        @NotNull
        public final Path file;
        @NotNull
        public final String format;

        public Combined() {
            this.enabled = ConfigYml.this.config.getBoolean("combined.enabled", true);
            this.file = ((ConfigYml)ConfigYml.this).plugin.logsFolder.resolve(ConfigYml.this.config.getString("combined.file", "commands.log"));
            this.format = ConfigYml.this.config.getString("combined.format", "[{date} {time}] [{player}] {command}");
        }

        @NotNull
        public String format(@NotNull ServerCommandEvent event) {
            return ConfigYml.this.plugin.processFormatVariables(this.format, event);
        }

        @NotNull
        public String format(@NotNull PlayerCommandPreprocessEvent event) {
            return ConfigYml.this.plugin.processFormatVariables(this.format, event);
        }
    }

    public class VariableFormats {
        @NotNull
        public final Date date = new Date();
        @NotNull
        public final Time time = new Time();

        public class Time {
            @NotNull
            public final SimpleDateFormat fileNames;
            @NotNull
            public final SimpleDateFormat formats;

            public Time() {
                this.fileNames = new SimpleDateFormat(ConfigYml.this.config.getString("variable-formats.time.file-names", "HH-mm-ss"));
                this.formats = new SimpleDateFormat(ConfigYml.this.config.getString("variable-formats.time.formats", "HH:mm:ss"));
            }
        }

        public class Date {
            @NotNull
            public final SimpleDateFormat fileNames;
            @NotNull
            public final SimpleDateFormat formats;

            public Date() {
                this.fileNames = new SimpleDateFormat(ConfigYml.this.config.getString("variable-formats.date.file-names", "yyyy-MM-dd"));
                this.formats = new SimpleDateFormat(ConfigYml.this.config.getString("variable-formats.date.formats", "MM-dd-yyyy"));
            }
        }
    }
}

