/*
 * Decompiled with CFR 0.152.
 */
package com.srnyx.commandlogger.libs.annoyingapi.file;

import com.srnyx.commandlogger.libs.annoyingapi.AnnoyingPlugin;
import com.srnyx.commandlogger.libs.annoyingapi.file.AnnoyingFile;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnoyingResource
extends AnnoyingFile<AnnoyingResource> {
    @NotNull
    private final String path;

    public AnnoyingResource(@NotNull AnnoyingPlugin plugin, @NotNull String path, @Nullable Options fileOptions) {
        super(plugin, path, fileOptions);
        this.path = path;
        fileOptions = fileOptions == null ? new Options() : fileOptions;
        this.load();
        if (fileOptions.createDefaultFile) {
            InputStream input = plugin.getResource(path);
            if (input == null) {
                return;
            }
            Path defaultPath = plugin.getDataFolder().toPath().resolve("default/" + path);
            plugin.attemptAsync(() -> {
                try {
                    Files.createDirectories(defaultPath.getParent(), new FileAttribute[0]);
                    Files.copy(input, defaultPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
    }

    public AnnoyingResource(@NotNull AnnoyingPlugin plugin, @NotNull String path) {
        this(plugin, path, (Options)null);
    }

    @Override
    public void create() {
        this.plugin.saveResource(this.path, this.fileOptions.replace);
    }

    public static class Options
    extends AnnoyingFile.Options<Options> {
        public boolean createDefaultFile = true;

        @NotNull
        public static Options load(@NotNull ConfigurationSection section) {
            Options options = AnnoyingFile.Options.load(new Options(), section);
            if (section.contains("createDefaultFile")) {
                options.createDefaultFile = section.getBoolean("createDefaultFile");
            }
            return options;
        }

        @NotNull
        public Options createDefaultFile(boolean createDefaultFile) {
            this.createDefaultFile = createDefaultFile;
            return this;
        }

        @Override
        @NotNull
        public String toString() {
            return "ResourceOptions{canBeEmpty=" + this.canBeEmpty + ",replace=" + this.replace + ",createDefaultFile=" + this.createDefaultFile + '}';
        }
    }
}

