/*
 * Decompiled with CFR 0.152.
 */
package com.srnyx.commandlogger.libs.annoyingapi.file;

import com.srnyx.commandlogger.libs.annoyingapi.libs.javautilities.parents.Stringable;
import com.srnyx.commandlogger.libs.annoyingapi.reflection.org.bukkit.RefWorld;
import com.srnyx.commandlogger.libs.annoyingapi.reflection.org.bukkit.entity.RefPlayer;
import java.lang.reflect.InvocationTargetException;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayableSound
extends Stringable {
    @NotNull
    public final Sound sound;
    @Nullable
    public final Object category;
    public final float volume;
    public final float pitch;

    public PlayableSound(@NotNull Sound sound, @Nullable Object category, float volume, float pitch) {
        this.sound = sound;
        this.category = category;
        this.volume = volume;
        this.pitch = pitch;
    }

    public PlayableSound(@NotNull Sound sound, @Nullable Object category) {
        this(sound, category, 1.0f, 1.0f);
    }

    public PlayableSound(@NotNull Sound sound, float volume, float pitch) {
        this(sound, null, volume, pitch);
    }

    public PlayableSound(@NotNull Sound sound) {
        this(sound, null, 1.0f, 1.0f);
    }

    public void play(@Nullable World world, @Nullable Location location) {
        if (world == null) {
            world = (World)Bukkit.getWorlds().get(0);
        }
        if (location == null) {
            location = world.getSpawnLocation();
        }
        if (this.category != null && RefWorld.WORLD_PLAY_SOUND_METHOD != null) {
            try {
                RefWorld.WORLD_PLAY_SOUND_METHOD.invoke((Object)world, location, this.sound, this.category, Float.valueOf(this.volume), Float.valueOf(this.pitch));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
            return;
        }
        world.playSound(location, this.sound, this.volume, this.pitch);
    }

    public void play(@Nullable World world) {
        this.play(world, null);
    }

    public void play(@NotNull Player player, @Nullable Location location) {
        if (location == null) {
            location = player.getLocation();
        }
        if (this.category != null && RefPlayer.PLAYER_PLAY_SOUND_METHOD != null) {
            try {
                RefPlayer.PLAYER_PLAY_SOUND_METHOD.invoke((Object)player, location, this.sound, this.category, Float.valueOf(this.volume), Float.valueOf(this.pitch));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
            return;
        }
        player.playSound(location, this.sound, this.volume, this.pitch);
    }

    public void play(@NotNull Player player) {
        this.play(player, null);
    }
}

