/*
 * Decompiled with CFR 0.152.
 */
package com.srnyx.commandlogger.libs.annoyingapi.libs.javautilities;

import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class MiscUtility {
    @SafeVarargs
    @NotNull
    public static <R> Optional<R> handleException(@NotNull Supplier<R> supplier, Class<? extends Throwable> ... throwables) {
        try {
            return Optional.ofNullable(supplier.get());
        }
        catch (Exception e) {
            for (Class<? extends Throwable> throwable : throwables) {
                if (!throwable.isInstance(e)) continue;
                return Optional.empty();
            }
            throw e;
        }
    }

    @NotNull
    public static <R> Optional<R> handleException(@NotNull Supplier<R> supplier) {
        return MiscUtility.handleException(supplier, Exception.class);
    }

    @NotNull
    public static Set<String> getEnumNames(@NotNull Class<? extends Enum<?>> enumClass) {
        return Arrays.stream(enumClass.getEnumConstants()).map(Enum::name).collect(Collectors.toSet());
    }

    private MiscUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

