/*
 * Decompiled with CFR 0.152.
 */
package com.srnyx.commandlogger.listeners;

import com.srnyx.commandlogger.CommandLogger;
import com.srnyx.commandlogger.config.Split;
import com.srnyx.commandlogger.libs.annoyingapi.AnnoyingListener;
import com.srnyx.commandlogger.libs.annoyingapi.AnnoyingPlugin;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import org.bukkit.event.EventHandler;
import org.bukkit.event.server.ServerCommandEvent;
import org.jetbrains.annotations.NotNull;

public class ConsoleCommandListener
extends AnnoyingListener {
    @NotNull
    private final CommandLogger plugin;

    public ConsoleCommandListener(@NotNull CommandLogger plugin) {
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public CommandLogger getAnnoyingPlugin() {
        return this.plugin;
    }

    @EventHandler
    public void onServerCommand(@NotNull ServerCommandEvent event) {
        if (!this.plugin.config.console.enabled) {
            this.unregister();
            return;
        }
        if (this.plugin.config.combined.enabled) {
            try {
                Files.createDirectories(this.plugin.config.combined.file.getParent(), new FileAttribute[0]);
                Files.write(this.plugin.config.combined.file, this.plugin.config.combined.format(event).getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            }
            catch (Exception e) {
                AnnoyingPlugin.log(Level.WARNING, "&cFailed to write to combined command log file for a console command!", e);
            }
        }
        if (this.plugin.config.console.combined.enabled) {
            try {
                Files.createDirectories(this.plugin.config.console.combined.file.getParent(), new FileAttribute[0]);
                Files.write(this.plugin.config.console.combined.file, this.plugin.config.console.combined.format(event).getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            }
            catch (Exception e) {
                AnnoyingPlugin.log(Level.WARNING, "&cFailed to write to combined console command log file!", e);
            }
        }
        for (Split split : this.plugin.config.console.splits) {
            try {
                Path file = this.plugin.logsFolder.resolve(this.plugin.processFileNameVariables(split.fileName));
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                Files.write(file, split.format(event).getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            }
            catch (Exception e) {
                AnnoyingPlugin.log(Level.WARNING, "&cFailed to write to console command log file!", e);
            }
        }
    }
}

