/*
 * Decompiled with CFR 0.152.
 */
package com.srnyx.commandlogger.listeners;

import com.srnyx.commandlogger.CommandLogger;
import com.srnyx.commandlogger.config.Split;
import com.srnyx.commandlogger.libs.annoyingapi.AnnoyingListener;
import com.srnyx.commandlogger.libs.annoyingapi.AnnoyingPlugin;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.jetbrains.annotations.NotNull;

public class PlayerCommandListener
extends AnnoyingListener {
    @NotNull
    private final CommandLogger plugin;

    public PlayerCommandListener(@NotNull CommandLogger plugin) {
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public CommandLogger getAnnoyingPlugin() {
        return this.plugin;
    }

    @EventHandler
    public void onPlayerCommandPreprocess(@NotNull PlayerCommandPreprocessEvent event) {
        if (!this.plugin.config.players.enabled) {
            this.unregister();
            return;
        }
        if (this.plugin.config.combined.enabled) {
            try {
                Files.createDirectories(this.plugin.config.combined.file.getParent(), new FileAttribute[0]);
                Files.write(this.plugin.config.combined.file, this.plugin.config.combined.format(event).getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            }
            catch (Exception e) {
                AnnoyingPlugin.log(Level.WARNING, "&cFailed to write to combined command log file for a player command!", e);
            }
        }
        Player player = event.getPlayer();
        if (this.plugin.config.players.combined.enabled && this.plugin.config.players.combined.hasRequiredPermission(player)) {
            try {
                Files.createDirectories(this.plugin.config.players.combined.file.getParent(), new FileAttribute[0]);
                Files.write(this.plugin.config.players.combined.file, this.plugin.config.players.combined.format(event).getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            }
            catch (Exception e) {
                AnnoyingPlugin.log(Level.WARNING, "&cFailed to write to combined player command log file!", e);
            }
        }
        if (this.plugin.config.players.splits.isEmpty()) {
            return;
        }
        String name = player.getName();
        String uuid = player.getUniqueId().toString();
        InetSocketAddress address = player.getAddress();
        String ip = address != null ? address.getAddress().getHostAddress() : "";
        for (Split.PlayerSplit split : this.plugin.config.players.splits) {
            if (!split.hasRequiredPermission(player)) continue;
            try {
                Path file = this.plugin.logsFolder.resolve(this.plugin.processFileNameVariables(split.fileName).replace("{player}", name).replace("{uuid}", uuid).replace("{ip}", ip));
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                Files.write(file, split.format(event).getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            }
            catch (Exception e) {
                AnnoyingPlugin.log(Level.WARNING, "&cFailed to write to player command log file for " + name + "!", e);
            }
        }
    }
}

