/*
 * Decompiled with CFR 0.152.
 */
package com.srnyx.commandlogger.config;

import com.srnyx.commandlogger.CommandLogger;
import com.srnyx.commandlogger.InfoForVariables;
import com.srnyx.commandlogger.config.ConfigLogger;
import com.srnyx.commandlogger.libs.annoyingapi.AnnoyingPlugin;
import com.srnyx.commandlogger.libs.annoyingapi.file.AnnoyingResource;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigYml {
    @NotNull
    private final CommandLogger plugin;
    @NotNull
    private final AnnoyingResource config;
    @NotNull
    public final Path logsFolder;
    public final boolean enabled;
    @Nullable
    public final Filters filters;
    @NotNull
    public final VariableFormats variableFormats;
    @NotNull
    public final List<ConfigLogger> loggers = new ArrayList<ConfigLogger>();
    @NotNull
    public final Players players;
    @NotNull
    public final Console console;

    public ConfigYml(@NotNull CommandLogger plugin) {
        this.plugin = plugin;
        this.config = new AnnoyingResource((AnnoyingPlugin)plugin, "config.yml");
        this.logsFolder = plugin.getDataFolder().toPath().resolve("logs");
        this.enabled = this.config.getBoolean("enabled", true);
        this.filters = Filters.getFilters(this.config.getConfigurationSection("filters"));
        this.variableFormats = new VariableFormats();
        this.players = new Players();
        this.console = new Console();
        for (Map map : this.config.getMapList("loggers")) {
            try {
                Boolean loggerEnabled = (Boolean)map.get("enabled");
                if (loggerEnabled == null || !loggerEnabled.booleanValue()) continue;
                this.loggers.add(new ConfigLogger(this, map));
            }
            catch (ClassCastException | IllegalArgumentException e) {
                AnnoyingPlugin.log(Level.WARNING, "&cFailed to load a command logger from config.yml due to invalid options! Skipping it...", e);
            }
        }
        if (this.config.contains("combined")) {
            Combined combined = new Combined();
            if (combined.enabled) {
                this.loggers.add(new ConfigLogger(this, combined.file, combined.format));
            }
        }
    }

    @NotNull
    protected String processVariables(@NotNull String string, @NotNull InfoForVariables info) {
        if (this.plugin.papiInstalled) {
            string = PlaceholderAPI.setPlaceholders((Player)(info.sender instanceof Player ? (Player)info.sender : null), (String)string);
        }
        String playerName = info.sender.getName();
        String uuid = "";
        String ip = "";
        if (info.sender instanceof Player) {
            Player player = (Player)info.sender;
            InetSocketAddress address = player.getAddress();
            uuid = player.getUniqueId().toString();
            ip = address != null ? address.getAddress().getHostAddress() : "";
        } else {
            playerName = "*" + playerName + "*";
        }
        String fullCommand = info.command.substring(1);
        String[] split = fullCommand.split(" ", 2);
        String baseCommand = split[0];
        String arguments = split.length > 1 ? split[1] : "";
        Date now = new Date();
        return string.replace("{date}", this.variableFormats.date.formats.format(now)).replace("{time}", this.variableFormats.time.formats.format(now)).replace("{player}", playerName).replace("{uuid}", uuid).replace("{ip}", ip).replace("{full_command}", fullCommand).replace("{base_command}", baseCommand).replace("{arguments}", arguments).replace("{command}", info.command);
    }

    @NotNull
    public String processFormatVariables(@NotNull String format, @NotNull InfoForVariables info) {
        return this.processVariables(format, info) + "\n";
    }

    public static class Filters {
        @Nullable
        public final Pattern include;
        @Nullable
        public final Pattern exclude;

        public Filters(@Nullable String include, @Nullable String exclude) {
            this.include = Filters.getFilter(include);
            this.exclude = Filters.getFilter(exclude);
        }

        public boolean doesNotPass(@NotNull String command) {
            if (this.exclude != null && this.exclude.matcher(command).matches()) {
                return true;
            }
            return this.include != null && !this.include.matcher(command).matches();
        }

        @Nullable
        public static Filters getFilters(@Nullable ConfigurationSection section) {
            return section != null ? new Filters(section.getString("include"), section.getString("exclude")) : null;
        }

        @Nullable
        public static Filters getFilters(@Nullable Map<?, ?> map) {
            try {
                return map != null ? new Filters((String)map.get("include"), (String)map.get("exclude")) : null;
            }
            catch (ClassCastException e) {
                AnnoyingPlugin.log(Level.WARNING, "&cFailed to load a command filter from config.yml due to invalid options! Skipping these filters...", e);
                return null;
            }
        }

        @Nullable
        private static Pattern getFilter(@Nullable String filter) {
            return filter != null && !filter.trim().isEmpty() ? Pattern.compile(filter) : null;
        }
    }

    public class VariableFormats {
        @NotNull
        public final Date date = new Date();
        @NotNull
        public final Time time = new Time();

        public class Date {
            @NotNull
            public final SimpleDateFormat fileNames;
            @NotNull
            public final SimpleDateFormat formats;

            public Date() {
                this.fileNames = new SimpleDateFormat(ConfigYml.this.config.getString("variable-formats.date.file-names", "yyyy-MM-dd"));
                this.formats = new SimpleDateFormat(ConfigYml.this.config.getString("variable-formats.date.formats", "MM-dd-yyyy"));
            }
        }

        public class Time {
            @NotNull
            public final SimpleDateFormat fileNames;
            @NotNull
            public final SimpleDateFormat formats;

            public Time() {
                this.fileNames = new SimpleDateFormat(ConfigYml.this.config.getString("variable-formats.time.file-names", "HH-mm-ss"));
                this.formats = new SimpleDateFormat(ConfigYml.this.config.getString("variable-formats.time.formats", "HH:mm:ss"));
            }
        }
    }

    public class Players {
        public final boolean enabled;
        @Nullable
        public final Filters filters;
        @NotNull
        public final List<ConfigLogger.PlayerLogger> loggers;

        public Players() {
            Boolean enabled;
            this.enabled = ConfigYml.this.config.getBoolean("players.enabled", true);
            this.filters = Filters.getFilters(ConfigYml.this.config.getConfigurationSection("players.filters"));
            this.loggers = new ArrayList<ConfigLogger.PlayerLogger>();
            for (Map map : ConfigYml.this.config.getMapList("players.loggers")) {
                try {
                    enabled = (Boolean)map.get("enabled");
                    if (enabled == null || !enabled.booleanValue()) continue;
                    this.loggers.add(new ConfigLogger.PlayerLogger(ConfigYml.this, map));
                }
                catch (ClassCastException | IllegalArgumentException e) {
                    AnnoyingPlugin.log(Level.WARNING, "&cFailed to load a player command logger from config.yml due to invalid options! Skipping it...", e);
                }
            }
            if (ConfigYml.this.config.contains("players.combined")) {
                Combined combined = new Combined();
                if (combined.enabled) {
                    this.loggers.add(new ConfigLogger.PlayerLogger(ConfigYml.this, combined.file, combined.format, combined.requiredPermission));
                }
            }
            for (Map map : ConfigYml.this.config.getMapList("players.splits")) {
                try {
                    enabled = (Boolean)map.get("enabled");
                    if (enabled == null || !enabled.booleanValue()) continue;
                    this.loggers.add(new ConfigLogger.PlayerLogger(ConfigYml.this, map));
                }
                catch (ClassCastException | IllegalArgumentException e) {
                    AnnoyingPlugin.log(Level.WARNING, "&cFailed to load a player command split from config.yml due to invalid options! Skipping it...", e);
                }
            }
        }

        @Deprecated
        private class Combined {
            public final boolean enabled;
            @NotNull
            public final String file;
            @Nullable
            public final String requiredPermission;
            @NotNull
            public final String format;

            private Combined() {
                this.enabled = ConfigYml.this.config.getBoolean("players.combined.enabled", false);
                this.file = ConfigYml.this.config.getString("players.combined.file", "players.log");
                this.requiredPermission = ConfigYml.this.config.getString("players.combined.required-permission");
                this.format = ConfigYml.this.config.getString("players.combined.format", "[{date} {time}] [{player}] /{full_command}");
            }
        }
    }

    public class Console {
        public final boolean enabled;
        @Nullable
        public final Filters filters;
        @NotNull
        public final List<ConfigLogger> loggers;

        public Console() {
            Boolean enabled;
            this.enabled = ConfigYml.this.config.getBoolean("console.enabled", true);
            this.filters = Filters.getFilters(ConfigYml.this.config.getConfigurationSection("console.filters"));
            this.loggers = new ArrayList<ConfigLogger>();
            for (Map map : ConfigYml.this.config.getMapList("console.loggers")) {
                try {
                    enabled = (Boolean)map.get("enabled");
                    if (enabled == null || !enabled.booleanValue()) continue;
                    this.loggers.add(new ConfigLogger(ConfigYml.this, map));
                }
                catch (ClassCastException | IllegalArgumentException e) {
                    AnnoyingPlugin.log(Level.WARNING, "&cFailed to load a console command logger from config.yml due to invalid options! Skipping it...", e);
                }
            }
            if (ConfigYml.this.config.contains("console.combined")) {
                Combined combined = new Combined();
                if (combined.enabled) {
                    this.loggers.add(new ConfigLogger(ConfigYml.this, combined.file, combined.format));
                }
            }
            for (Map map : ConfigYml.this.config.getMapList("console.splits")) {
                try {
                    enabled = (Boolean)map.get("enabled");
                    if (enabled == null || !enabled.booleanValue()) continue;
                    this.loggers.add(new ConfigLogger(ConfigYml.this, map));
                }
                catch (ClassCastException | IllegalArgumentException e) {
                    AnnoyingPlugin.log(Level.WARNING, "&cFailed to load a console split from config.yml due to invalid options! Skipping it...", e);
                }
            }
        }

        @Deprecated
        private class Combined {
            public final boolean enabled;
            @NotNull
            public final String file;
            @NotNull
            public final String format;

            private Combined() {
                this.enabled = ConfigYml.this.config.getBoolean("console.combined.enabled", false);
                this.file = ConfigYml.this.config.getString("console.combined.file", "console.log");
                this.format = ConfigYml.this.config.getString("console.combined.format", "[{date} {time}] /{full_command}");
            }
        }
    }

    @Deprecated
    public class Combined {
        public final boolean enabled;
        @NotNull
        public final String file;
        @NotNull
        public final String format;

        public Combined() {
            this.enabled = ConfigYml.this.config.getBoolean("combined.enabled", false);
            this.file = ConfigYml.this.config.getString("combined.file", "commands.log");
            this.format = ConfigYml.this.config.getString("combined.format", "[{date} {time}] [{player}] /{full_command}");
        }

        @NotNull
        public String format(@NotNull InfoForVariables info) {
            return ConfigYml.this.processFormatVariables(this.format, info);
        }
    }
}

