/*
 * Decompiled with CFR 0.152.
 */
package com.srnyx.commandlogger.libs.annoyingapi.command.selector.selectors;

import com.srnyx.commandlogger.libs.annoyingapi.command.AnnoyingSender;
import com.srnyx.commandlogger.libs.annoyingapi.command.selector.Selector;
import java.util.Collections;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NearestEntitySelector
implements Selector<Entity> {
    @Override
    @NotNull
    public Class<Entity> getType() {
        return Entity.class;
    }

    @Override
    @Nullable
    public List<Entity> expand(@NotNull AnnoyingSender sender) {
        Player player = sender.getPlayerOrNull();
        if (player == null) {
            return null;
        }
        Location playerLocation = player.getLocation();
        Entity nearest = null;
        double nearestDistanceSquared = Double.MAX_VALUE;
        for (Entity entity : player.getWorld().getEntities()) {
            double distanceSquared;
            if (entity.equals((Object)player) || !((distanceSquared = entity.getLocation().distanceSquared(playerLocation)) < nearestDistanceSquared)) continue;
            nearest = entity;
            nearestDistanceSquared = distanceSquared;
        }
        return nearest == null ? Collections.emptyList() : Collections.singletonList(nearest);
    }
}

