/*
 * Decompiled with CFR 0.152.
 */
package com.srnyx.commandlogger.libs.annoyingapi.data;

import com.srnyx.commandlogger.libs.annoyingapi.AnnoyingPlugin;
import com.srnyx.commandlogger.libs.annoyingapi.data.Data;
import com.srnyx.commandlogger.libs.annoyingapi.library.RuntimeLibrary;
import com.srnyx.commandlogger.libs.annoyingapi.reflection.org.bukkit.RefNamespacedKey;
import com.srnyx.commandlogger.libs.annoyingapi.reflection.org.bukkit.inventory.meta.RefItemMeta;
import com.srnyx.commandlogger.libs.annoyingapi.reflection.org.bukkit.inventory.meta.tags.RefCustomItemTagContainer;
import com.srnyx.commandlogger.libs.annoyingapi.reflection.org.bukkit.inventory.meta.tags.RefItemTagType;
import com.srnyx.commandlogger.libs.annoyingapi.reflection.org.bukkit.persistence.RefPersistentDataContainer;
import com.srnyx.commandlogger.libs.annoyingapi.reflection.org.bukkit.persistence.RefPersistentDataHolder;
import com.srnyx.commandlogger.libs.annoyingapi.reflection.org.bukkit.persistence.RefPersistentDataType;
import com.srnyx.commandlogger.libs.nbtapi.NBT;
import java.util.Optional;
import java.util.function.Supplier;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemData
extends Data<ItemStack> {
    public ItemData(@NotNull AnnoyingPlugin plugin, @NotNull ItemStack item) {
        super(plugin, new ItemStack(item));
    }

    @NotNull
    public Optional<String> attemptItemNbtApi(@NotNull Supplier<String> supplier) {
        this.plugin.libraryManager.loadLibrary(RuntimeLibrary.ITEM_NBT_API);
        return Optional.ofNullable(supplier.get());
    }

    public void attemptItemNbtApi(@NotNull Runnable runnable) {
        this.plugin.libraryManager.loadLibrary(RuntimeLibrary.ITEM_NBT_API);
        runnable.run();
    }

    @Override
    @Nullable
    public String get(@NotNull String key) {
        if (RefNamespacedKey.NAMESPACED_KEY_CONSTRUCTOR != null) {
            ItemMeta meta = ((ItemStack)this.target).getItemMeta();
            if (meta == null) {
                return null;
            }
            if (RefPersistentDataHolder.PERSISTENT_DATA_HOLDER_GET_PERSISTENT_DATA_CONTAINER_METHOD != null && RefPersistentDataContainer.PERSISTENT_DATA_CONTAINER_GET_METHOD != null && RefPersistentDataType.PERSISTENT_DATA_TYPE_STRING != null) {
                try {
                    return (String)RefPersistentDataContainer.PERSISTENT_DATA_CONTAINER_GET_METHOD.invoke(RefPersistentDataHolder.PERSISTENT_DATA_HOLDER_GET_PERSISTENT_DATA_CONTAINER_METHOD.invoke((Object)meta, new Object[0]), RefNamespacedKey.NAMESPACED_KEY_CONSTRUCTOR.newInstance(new Object[]{this.plugin, key}), RefPersistentDataType.PERSISTENT_DATA_TYPE_STRING);
                }
                catch (ReflectiveOperationException e) {
                    this.sendError("get", e);
                    return null;
                }
            }
            if (RefItemMeta.ITEM_META_GET_CUSTOM_TAG_CONTAINER_METHOD != null && RefCustomItemTagContainer.CUSTOM_ITEM_TAG_CONTAINER_GET_CUSTOM_TAG_METHOD != null) {
                try {
                    return (String)RefCustomItemTagContainer.CUSTOM_ITEM_TAG_CONTAINER_GET_CUSTOM_TAG_METHOD.invoke(RefItemMeta.ITEM_META_GET_CUSTOM_TAG_CONTAINER_METHOD.invoke((Object)meta, new Object[0]), RefNamespacedKey.NAMESPACED_KEY_CONSTRUCTOR.newInstance(new Object[]{this.plugin, key}), RefItemTagType.ITEM_TAG_TYPE_STRING);
                }
                catch (ReflectiveOperationException e) {
                    this.sendError("get", e);
                    return null;
                }
            }
        }
        return this.attemptItemNbtApi(() -> (String)NBT.get((ItemStack)((ItemStack)this.target), nbt -> nbt.getString(key))).orElse(null);
    }

    @Override
    protected boolean set(@NotNull String key, @NotNull String value) {
        if (RefNamespacedKey.NAMESPACED_KEY_CONSTRUCTOR != null) {
            ItemMeta meta = ((ItemStack)this.target).getItemMeta();
            if (meta == null) {
                this.sendError("set", null);
                return false;
            }
            if (RefPersistentDataHolder.PERSISTENT_DATA_HOLDER_GET_PERSISTENT_DATA_CONTAINER_METHOD != null && RefPersistentDataContainer.PERSISTENT_DATA_CONTAINER_SET_METHOD != null) {
                try {
                    RefPersistentDataContainer.PERSISTENT_DATA_CONTAINER_SET_METHOD.invoke(RefPersistentDataHolder.PERSISTENT_DATA_HOLDER_GET_PERSISTENT_DATA_CONTAINER_METHOD.invoke((Object)meta, new Object[0]), RefNamespacedKey.NAMESPACED_KEY_CONSTRUCTOR.newInstance(new Object[]{this.plugin, key}), RefPersistentDataType.PERSISTENT_DATA_TYPE_STRING, value);
                    ((ItemStack)this.target).setItemMeta(meta);
                    return true;
                }
                catch (ReflectiveOperationException e) {
                    this.sendError("set", e);
                    return false;
                }
            }
            if (RefItemMeta.ITEM_META_GET_CUSTOM_TAG_CONTAINER_METHOD != null && RefCustomItemTagContainer.CUSTOM_ITEM_TAG_CONTAINER_SET_CUSTOM_TAG_METHOD != null) {
                try {
                    RefCustomItemTagContainer.CUSTOM_ITEM_TAG_CONTAINER_SET_CUSTOM_TAG_METHOD.invoke(RefItemMeta.ITEM_META_GET_CUSTOM_TAG_CONTAINER_METHOD.invoke((Object)meta, new Object[0]), RefNamespacedKey.NAMESPACED_KEY_CONSTRUCTOR.newInstance(new Object[]{this.plugin, key}), RefItemTagType.ITEM_TAG_TYPE_STRING, value);
                    ((ItemStack)this.target).setItemMeta(meta);
                    return true;
                }
                catch (ReflectiveOperationException e) {
                    this.sendError("set", e);
                    return false;
                }
            }
        }
        this.attemptItemNbtApi(() -> NBT.modify((ItemStack)((ItemStack)this.target), nbt -> nbt.setString(key, value)));
        return true;
    }

    @Override
    public boolean remove(@NotNull String key) {
        if (RefNamespacedKey.NAMESPACED_KEY_CONSTRUCTOR != null) {
            ItemMeta meta = ((ItemStack)this.target).getItemMeta();
            if (meta == null) {
                this.sendError("remove", null);
                return false;
            }
            if (RefPersistentDataHolder.PERSISTENT_DATA_HOLDER_GET_PERSISTENT_DATA_CONTAINER_METHOD != null && RefPersistentDataContainer.PERSISTENT_DATA_CONTAINER_REMOVE_METHOD != null) {
                try {
                    RefPersistentDataContainer.PERSISTENT_DATA_CONTAINER_REMOVE_METHOD.invoke(RefPersistentDataHolder.PERSISTENT_DATA_HOLDER_GET_PERSISTENT_DATA_CONTAINER_METHOD.invoke((Object)meta, new Object[0]), RefNamespacedKey.NAMESPACED_KEY_CONSTRUCTOR.newInstance(new Object[]{this.plugin, key}));
                    ((ItemStack)this.target).setItemMeta(meta);
                    return true;
                }
                catch (ReflectiveOperationException e) {
                    this.sendError("remove", e);
                    return false;
                }
            }
            if (RefItemMeta.ITEM_META_GET_CUSTOM_TAG_CONTAINER_METHOD != null && RefCustomItemTagContainer.CUSTOM_ITEM_TAG_CONTAINER_REMOVE_CUSTOM_TAG_METHOD != null) {
                try {
                    RefCustomItemTagContainer.CUSTOM_ITEM_TAG_CONTAINER_REMOVE_CUSTOM_TAG_METHOD.invoke(RefItemMeta.ITEM_META_GET_CUSTOM_TAG_CONTAINER_METHOD.invoke((Object)meta, new Object[0]), RefNamespacedKey.NAMESPACED_KEY_CONSTRUCTOR.newInstance(new Object[]{this.plugin, key}));
                    ((ItemStack)this.target).setItemMeta(meta);
                    return true;
                }
                catch (ReflectiveOperationException e) {
                    this.sendError("remove", e);
                    return false;
                }
            }
        }
        this.attemptItemNbtApi(() -> NBT.modify((ItemStack)((ItemStack)this.target), nbt -> nbt.removeKey(key)));
        return true;
    }
}

