/*
 * Decompiled with CFR 0.152.
 */
package com.srnyx.commandlogger.libs.annoyingapi.libs.javautilities;

import java.text.DecimalFormat;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringUtility {
    @NotNull
    public static String repeat(@NotNull CharSequence charSequence, int amount) {
        return String.join((CharSequence)"", Collections.nCopies(amount, charSequence));
    }

    @NotNull
    public static String formatNumber(@NotNull Number value, @Nullable String pattern) {
        if (pattern == null) {
            pattern = "#,###.##";
        }
        return new DecimalFormat(pattern).format(value);
    }

    @NotNull
    public static String formatNumber(@NotNull Number value) {
        return StringUtility.formatNumber(value, null);
    }

    @NotNull
    public static String shorten(@NotNull String string, int length) {
        if (length < 3) {
            throw new IllegalArgumentException("Length must be at least 3");
        }
        return string.length() + 3 > length ? string.substring(0, length - 3) + "..." : string;
    }

    private StringUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

