/*
 * Decompiled with CFR 0.152.
 */
package com.srnyx.commandlogger.libs.annoyingapi.message;

import com.srnyx.commandlogger.libs.annoyingapi.libs.javautilities.StringUtility;
import com.srnyx.commandlogger.libs.annoyingapi.libs.javautilities.manipulation.DurationFormatter;
import com.srnyx.commandlogger.libs.annoyingapi.message.ReplaceType;
import java.util.function.BinaryOperator;
import org.jetbrains.annotations.NotNull;

public enum DefaultReplaceType implements ReplaceType
{
    TIME("mm':'ss", (input, value) -> {
        try {
            return DurationFormatter.formatDuration(Long.parseLong(value), input);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }),
    NUMBER("#,###.##", (input, value) -> {
        try {
            return StringUtility.formatNumber(Double.parseDouble(value), input);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }),
    BOOLEAN("true//false", (input, value) -> {
        String[] split = input.split("//", 2);
        boolean bool = Boolean.parseBoolean(value);
        if (split.length != 2) {
            return bool ? "true" : "false";
        }
        return bool ? split[0] : split[1];
    });

    @NotNull
    private final String defaultInput;
    @NotNull
    private final BinaryOperator<String> outputOperator;

    private DefaultReplaceType(String defaultInput, BinaryOperator<String> outputOperator) {
        this.defaultInput = defaultInput;
        this.outputOperator = outputOperator;
    }

    @Override
    @NotNull
    public String getDefaultInput() {
        return this.defaultInput;
    }

    @Override
    @NotNull
    public BinaryOperator<String> getOutputOperator() {
        return this.outputOperator;
    }
}

