/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsutils.commands;

import dev.xdpxi.xdsutils.Main;
import dev.xdpxi.xdsutils.utils.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public record XDsUtils(Main plugin) implements CommandExecutor,
TabCompleter
{
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 0) {
            return false;
        }
        return switch (args[0].toLowerCase()) {
            case "reload" -> this.reloadConfig(sender);
            case "backup" -> {
                if (args.length > 1) {
                    switch (args[1].toLowerCase()) {
                        case "status": {
                            yield this.backupStatus(sender);
                        }
                    }
                    yield this.backupServer(sender);
                }
                yield this.backupServer(sender);
            }
            default -> false;
        };
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (args.length == 1) {
            return Arrays.asList("reload", "backup");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("backup")) {
            return Arrays.asList("status");
        }
        return new ArrayList<String>();
    }

    private boolean hasPermission(CommandSender sender, String permission) {
        if (sender.hasPermission(permission) || sender.isOp()) {
            return false;
        }
        sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to perform this action!");
        return true;
    }

    private boolean reloadConfig(CommandSender sender) {
        if (this.hasPermission(sender, "xdsutils.reload")) {
            return false;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, Config::reload);
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Configuration reloaded successfully!");
        return true;
    }

    private boolean backupServer(CommandSender sender) {
        if (this.hasPermission(sender, "xdsutils.backup")) {
            return false;
        }
        if (Main.backupManager.isRunning.get()) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "A backup is already running. Please wait until it finishes.");
            return true;
        }
        Main.backupManager.runBackupNow();
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Backup started successfully!");
        return true;
    }

    private boolean backupStatus(CommandSender sender) {
        if (this.hasPermission(sender, "xdsutils.backup")) {
            return false;
        }
        if (Main.backupManager.isRunning.get()) {
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "A backup is currently running.");
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "No backup is currently running.");
        return true;
    }
}

