/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsutils;

import dev.xdpxi.xdsutils.utils.Config;
import dev.xdpxi.xdsutils.utils.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Backup {
    public final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final JavaPlugin plugin;
    private final File backupsRoot;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    private boolean enabled;
    private int maxBackups;
    private int compressionLevel;
    private int maxSizeMB;
    private final Map<String, Integer> worldIntervals = new HashMap<String, Integer>();
    private final Map<String, Integer> backupTasks = new HashMap<String, Integer>();
    public int totalBackups = 0;

    public Backup(JavaPlugin pluginInstance) {
        this.plugin = pluginInstance;
        this.backupsRoot = new File(this.plugin.getDataFolder(), "backups");
    }

    public void reload() {
        this.enabled = Config.config.getBoolean("enable_backups", true);
        this.maxSizeMB = Config.config.getInt("max_size", 1024);
        this.maxBackups = Config.config.getInt("max_backups", 10);
        this.compressionLevel = Config.config.getInt("compression_level", 9);
        this.worldIntervals.clear();
        List worldList = Config.config.getMapList("worlds");
        for (Map entry : worldList) {
            for (Map.Entry e : entry.entrySet()) {
                String worldName = String.valueOf(e.getKey());
                int interval = Integer.parseInt(String.valueOf(e.getValue()));
                this.worldIntervals.put(worldName, interval);
            }
        }
        this.updateTotalBackups();
    }

    public void startBackups() {
        if (!this.enabled) {
            return;
        }
        if (!this.backupsRoot.exists()) {
            this.backupsRoot.mkdirs();
        }
        this.stopBackups();
        HashMap<Integer, List> intervalGroups = new HashMap<Integer, List>();
        for (Map.Entry<String, Integer> entry : this.worldIntervals.entrySet()) {
            intervalGroups.computeIfAbsent(entry.getValue(), k -> new ArrayList()).add(entry.getKey());
        }
        for (Map.Entry<String, Integer> entry : intervalGroups.entrySet()) {
            int intervalMinutes = (Integer)((Object)entry.getKey());
            List worlds = (List)((Object)entry.getValue());
            int taskId = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> this.createBackupsForWorlds(worlds), 0L, (long)intervalMinutes * 60L * 20L).getTaskId();
            this.backupTasks.put("interval_" + intervalMinutes, taskId);
            Log.info("Scheduled backup for " + worlds.size() + " worlds every " + intervalMinutes + " minutes.");
        }
    }

    public void stopBackups() {
        for (int taskId : this.backupTasks.values()) {
            Bukkit.getScheduler().cancelTask(taskId);
        }
        this.backupTasks.clear();
        Log.info("All backup schedules stopped.");
    }

    public void runBackupNow() {
        if (this.isRunning.get()) {
            Log.info("A backup is already running. Skipping manual backup.");
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, this::createAllWorldBackups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAllWorldBackups() {
        if (!this.isRunning.compareAndSet(false, true)) {
            return;
        }
        try {
            ArrayList<Thread> threads = new ArrayList<Thread>();
            for (String worldName : this.worldIntervals.keySet()) {
                Thread t = new Thread(() -> this.createBackup(worldName));
                t.start();
                threads.add(t);
            }
            for (Thread t : threads) {
                try {
                    t.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Exception e) {
            Log.error("Failed to create backups!");
            e.printStackTrace();
        }
        finally {
            this.isRunning.set(false);
            this.updateTotalBackups();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBackupsForWorlds(List<String> worlds) {
        if (!this.isRunning.compareAndSet(false, true)) {
            return;
        }
        try {
            ArrayList<Thread> threads = new ArrayList<Thread>();
            for (String worldName : worlds) {
                Thread t = new Thread(() -> this.createBackup(worldName));
                t.start();
                threads.add(t);
            }
            for (Thread t : threads) {
                try {
                    t.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            this.isRunning.set(false);
            this.updateTotalBackups();
        }
    }

    private void createBackup(String worldName) {
        try {
            File worldFolder = new File(worldName);
            if (!worldFolder.exists()) {
                Log.warn("World not found: " + worldName);
                return;
            }
            File worldBackupFolder = new File(this.backupsRoot, worldName);
            if (!worldBackupFolder.exists()) {
                worldBackupFolder.mkdirs();
            }
            String timestamp = this.dateFormat.format(new Date());
            File tempBackup = new File(worldBackupFolder, "backup_" + timestamp + ".zip.tmp");
            File finalBackup = new File(worldBackupFolder, "backup_" + timestamp + ".zip");
            Log.info("Creating backup for world '" + worldName + "'...");
            try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(tempBackup));){
                zos.setLevel(this.compressionLevel);
                this.zipFolder(worldFolder.toPath(), worldFolder.getName(), zos);
            }
            Files.move(tempBackup.toPath(), finalBackup.toPath(), StandardCopyOption.ATOMIC_MOVE);
            Log.info("Backup created: " + finalBackup.getName());
            this.enforceBackupLimits(worldBackupFolder);
        }
        catch (Exception e) {
            Log.error("Failed to back up world: " + worldName);
            e.printStackTrace();
        }
    }

    private void zipFolder(Path folder, String parentFolder, ZipOutputStream zos) throws IOException {
        List<Path> paths = Files.walk(folder, new FileVisitOption[0]).toList();
        int counter = 0;
        for (Path path : paths) {
            File file = path.toFile();
            String fileName = file.getName();
            if (fileName.equals("session.lock")) continue;
            if (path.toFile().isDirectory() && fileName.equalsIgnoreCase("backups")) {
                Log.info("Skipping backups folder: " + file.getAbsolutePath());
                continue;
            }
            String zipEntryName = parentFolder + File.separator + String.valueOf(folder.relativize(path));
            if (file.isDirectory() && !zipEntryName.endsWith("/")) {
                zipEntryName = zipEntryName + "/";
            }
            try {
                zos.putNextEntry(new ZipEntry(zipEntryName));
                if (!file.isDirectory()) {
                    Files.copy(path, zos);
                }
                zos.closeEntry();
            }
            catch (IOException e) {
                Log.warn("Could not copy file: " + file.getAbsolutePath());
            }
            if (++counter % 100 != 0) continue;
            Log.info("Processed " + counter + " files for world " + parentFolder);
        }
    }

    private void enforceBackupLimits(File worldBackupFolder) {
        File[] files = worldBackupFolder.listFiles((dir, name) -> name.endsWith(".zip"));
        if (files == null || files.length == 0) {
            return;
        }
        Arrays.sort(files, Comparator.comparingLong(File::lastModified));
        long totalSizeMB = Arrays.stream(files).mapToLong(f -> f.length() / 0x100000L).sum();
        int currentCount = files.length;
        for (int index = 0; (currentCount > this.maxBackups || totalSizeMB > (long)this.maxSizeMB) && index < files.length; ++index) {
            File file = files[index];
            long fileSizeMB = file.length() / 0x100000L;
            if (file.delete()) {
                Log.info("Deleted old backup: " + file.getName());
                totalSizeMB -= fileSizeMB;
                --currentCount;
                continue;
            }
            Log.warn("Could not delete old backup: " + file.getName());
        }
    }

    public void updateTotalBackups() {
        this.totalBackups = 0;
        for (String worldName : this.worldIntervals.keySet()) {
            File[] files;
            File worldBackupFolder = new File(this.backupsRoot, worldName);
            if (!worldBackupFolder.exists() || (files = worldBackupFolder.listFiles((dir, name) -> name.endsWith(".zip"))) == null) continue;
            this.totalBackups += files.length;
        }
    }
}

