/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsutils.commands;

import dev.xdpxi.xdsutils.Main;
import dev.xdpxi.xdsutils.utils.Config;
import dev.xdpxi.xdsutils.utils.Economy;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public record Shop(Main plugin) implements CommandExecutor,
Listener
{
    private static void openShop(Player player) {
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)(String.valueOf(ChatColor.GREEN) + "Shop"));
        List shopItems = Config.config.getMapList("shop_items");
        for (Map map : shopItems) {
            for (Object key : map.keySet()) {
                String itemKey = key.toString();
                Map data = (Map)map.get(key);
                int cost = (Integer)data.get("cost");
                int amount = (Integer)data.get("amount");
                int slot = (Integer)data.get("slot");
                Material material = Material.matchMaterial((String)itemKey.replace("minecraft:", ""));
                if (material == null) continue;
                ItemStack item = new ItemStack(material, amount);
                ItemMeta meta = item.getItemMeta();
                meta.setDisplayName(String.valueOf(ChatColor.YELLOW) + material.name());
                ArrayList<CallSite> lore = new ArrayList<CallSite>();
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.GREEN) + "Buy: " + cost)));
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.RED) + "Right-click to sell")));
                meta.setLore(lore);
                item.setItemMeta(meta);
                inv.setItem(slot, item);
            }
        }
        player.openInventory(inv);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!Config.config.getBoolean("enable_shop")) {
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        Shop.openShop(player);
        return true;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getClickedInventory() == null || event.getView().getTitle() == null) {
            return;
        }
        if (!ChatColor.stripColor((String)event.getView().getTitle()).equalsIgnoreCase("Shop")) {
            return;
        }
        if (!Config.config.getBoolean("enable_shop")) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        String materialName = clicked.getType().name().toLowerCase();
        List shopItems = Config.config.getMapList("shop_items");
        for (Map map : shopItems) {
            for (Object key : map.keySet()) {
                String itemKey = key.toString().replace("minecraft:", "");
                if (!itemKey.equalsIgnoreCase(materialName)) continue;
                Map data = (Map)map.get(key);
                int cost = (Integer)data.get("cost");
                int amount = (Integer)data.get("amount");
                UUID uuid = player.getUniqueId();
                double balance = Economy.getBalance(uuid);
                if (event.isLeftClick()) {
                    if (balance < (double)cost) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have enough money!");
                        return;
                    }
                    ItemStack item = new ItemStack(clicked.getType(), amount);
                    player.getInventory().addItem(new ItemStack[]{item});
                    Economy.setBalance(uuid, balance - (double)cost);
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Bought " + amount + " " + itemKey + " for " + cost);
                    continue;
                }
                if (!event.isRightClick()) continue;
                if (player.getInventory().contains(clicked.getType(), amount)) {
                    player.getInventory().removeItem(new ItemStack[]{new ItemStack(clicked.getType(), amount)});
                    Economy.setBalance(uuid, balance + (double)cost);
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Sold " + amount + " " + itemKey + " for " + cost);
                    continue;
                }
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have any " + itemKey + " to sell!");
            }
        }
    }
}

