/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsutils.commands;

import dev.xdpxi.xdsutils.Main;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public record Heal(Main plugin) implements CommandExecutor,
TabCompleter
{
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can heal themselves.");
                return true;
            }
            Player player = (Player)sender;
            this.healPlayer(player);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have been healed!");
            return true;
        }
        if (!sender.hasPermission("xdsutils.heal") && !sender.isOp()) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to heal others!");
            return true;
        }
        Player target = Bukkit.getPlayerExact((String)args[0]);
        if (target == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
            return true;
        }
        this.healPlayer(target);
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "You healed " + target.getName() + ".");
        target.sendMessage(String.valueOf(ChatColor.GREEN) + "You have been healed by " + sender.getName() + "!");
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1 && (sender.hasPermission("xdsutils.heal") || sender.isOp())) {
            Bukkit.getOnlinePlayers().forEach(p -> completions.add(p.getName()));
        }
        return completions;
    }

    private void healPlayer(@NotNull Player player) {
        player.setHealth(player.getMaxHealth());
        player.setFoodLevel(20);
        player.setSaturation(20.0f);
        player.setFireTicks(0);
    }
}

