/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsutils;

import dev.xdpxi.xdsutils.Backup;
import dev.xdpxi.xdsutils.WebServer;
import dev.xdpxi.xdsutils.commands.Heal;
import dev.xdpxi.xdsutils.commands.XDsUtils;
import dev.xdpxi.xdsutils.listeners.ChatListener;
import dev.xdpxi.xdsutils.listeners.ContainerOpenListener;
import dev.xdpxi.xdsutils.listeners.FirstJoinListener;
import dev.xdpxi.xdsutils.listeners.ItemPickupListener;
import dev.xdpxi.xdsutils.listeners.ItemSpawnListener;
import dev.xdpxi.xdsutils.listeners.JoinListener;
import dev.xdpxi.xdsutils.listeners.PrepareCraftListener;
import dev.xdpxi.xdsutils.listeners.PrepareSmithingListener;
import dev.xdpxi.xdsutils.listeners.QuitListener;
import dev.xdpxi.xdsutils.utils.Config;
import dev.xdpxi.xdsutils.utils.Log;
import dev.xdpxi.xdsutils.utils.Metrics;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Main
extends JavaPlugin {
    public static Backup backupManager;
    public static Set<String> disabledItems;

    public void onEnable() {
        Log.info("Enabling XD's Utils...");
        backupManager = new Backup(this);
        Metrics metrics = new Metrics((Plugin)this, 26548);
        Config.init(this);
        if (Config.config.getBoolean("enable_web")) {
            WebServer.startAsync();
        }
        backupManager.reload();
        if (Config.config.getBoolean("enable_backups")) {
            backupManager.startBackups();
        }
        Objects.requireNonNull(this.getCommand("xdsutils")).setExecutor((CommandExecutor)new XDsUtils(this));
        Objects.requireNonNull(this.getCommand("xdsutils")).setTabCompleter((TabCompleter)new XDsUtils(this));
        Objects.requireNonNull(this.getCommand("heal")).setExecutor((CommandExecutor)new Heal(this));
        Objects.requireNonNull(this.getCommand("heal")).setTabCompleter((TabCompleter)new Heal(this));
        List list = Config.config.getStringList("disabled_items");
        disabledItems.clear();
        for (String s : list) {
            disabledItems.add(s.toLowerCase());
        }
        this.getServer().getPluginManager().registerEvents((Listener)new JoinListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new QuitListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new FirstJoinListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChatListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PrepareSmithingListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PrepareCraftListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ItemPickupListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ItemSpawnListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ContainerOpenListener(), (Plugin)this);
        Bukkit.getScheduler().runTaskTimer((Plugin)this, Main::checkAndClearDisabledItems, 0L, 20L);
        Log.info("Enabled XD's Utils!");
    }

    public void onDisable() {
        Log.info("Disabling XD's Utils...");
        WebServer.stop();
        backupManager.stopBackups();
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        Log.info("Disabled XD's Utils!");
    }

    public static void checkAndClearDisabledItems() {
        if (Config.config.getInt("disable_method") == 2) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                ItemStack[] contents = player.getInventory().getContents();
                boolean updated = false;
                for (int i = 0; i < contents.length; ++i) {
                    String namespacedId;
                    ItemStack item = contents[i];
                    if (item == null || !disabledItems.contains(namespacedId = "minecraft:" + item.getType().toString().toLowerCase())) continue;
                    contents[i] = null;
                    updated = true;
                }
                if (!updated) continue;
                player.getInventory().setContents(contents);
                player.sendMessage(String.valueOf(ChatColor.RED) + "A disabled item has been removed from your inventory!");
            }
        }
    }

    public static boolean isItemDisabled(ItemStack item) {
        if (item == null) {
            return false;
        }
        NamespacedKey key = item.getType().getKey();
        if (disabledItems.contains(key.toString().toLowerCase())) {
            return true;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta != null && meta.hasDisplayName()) {
            String displayName = meta.getDisplayName().toLowerCase();
            return disabledItems.contains(displayName);
        }
        return false;
    }

    static {
        disabledItems = new HashSet<String>();
    }
}

