/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsutils;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import dev.xdpxi.xdsutils.Main;
import dev.xdpxi.xdsutils.utils.Config;
import dev.xdpxi.xdsutils.utils.Helpers;
import dev.xdpxi.xdsutils.utils.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.World;

public class WebServer {
    private static HttpServer server;
    private static final AtomicBoolean running;

    public static void startAsync() {
        if (!running.compareAndSet(false, true)) {
            Log.warn("WebServer is already starting or running!");
            return;
        }
        new Thread(() -> {
            try {
                WebServer.start();
                running.set(server != null);
            }
            catch (IOException e) {
                try {
                    Log.error("Failed to start WebServer: " + e.getMessage());
                    running.set(server != null);
                }
                catch (Throwable throwable) {
                    running.set(server != null);
                    throw throwable;
                }
            }
        }, "WebServer-Thread").start();
    }

    public static void start() throws IOException {
        if (server != null) {
            Log.warn("WebServer is already running!");
            return;
        }
        int basePort = Config.config.getInt("port", 8080);
        int port = WebServer.findAvailablePort(basePort);
        if (port == -1) {
            Log.error("No available ports from " + basePort + " to 65535.");
            running.set(false);
            return;
        }
        server = HttpServer.create(new InetSocketAddress(port), 0);
        Log.info("WebServer started at http://localhost:" + port);
        WebServer.registerContexts(server);
        server.setExecutor(null);
        server.start();
    }

    private static int findAvailablePort(int startPort) {
        for (int port = startPort; port < 65535; ++port) {
            try {
                HttpServer testServer = HttpServer.create(new InetSocketAddress(port), 0);
                testServer.stop(0);
                return port;
            }
            catch (IOException ignored) {
                Log.warn("Port " + port + " is in use, trying next...");
                continue;
            }
        }
        return -1;
    }

    private static void registerContexts(HttpServer srv) {
        srv.createContext("/", exchange -> {
            try (InputStream is = WebServer.class.getResourceAsStream("/index.html");){
                if (is == null) {
                    WebServer.sendTextResponse(exchange, 404, "index.html not found in resources!");
                    return;
                }
                byte[] response = is.readAllBytes();
                exchange.getResponseHeaders().add("Content-Type", "text/html; charset=utf-8");
                WebServer.sendBytes(exchange, 200, response);
            }
            catch (Exception e) {
                Log.error("Error serving index.html: " + e.getMessage());
                WebServer.sendTextResponse(exchange, 500, "Internal server error");
            }
        });
        srv.createContext("/api/", exchange -> {
            try {
                exchange.getResponseHeaders().add("Content-Type", "application/json; charset=utf-8");
                String json = WebServer.buildApiResponse();
                WebServer.sendTextResponse(exchange, 200, json);
            }
            catch (Exception e) {
                Log.error("Error while building /api/ response: " + e.getMessage());
                WebServer.sendTextResponse(exchange, 500, "{\"error\":\"internal\"}");
            }
        });
    }

    private static String buildApiResponse() {
        int players = Bukkit.getOnlinePlayers().size();
        int maxPlayers = Bukkit.getMaxPlayers();
        long ramUsed = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L / 1024L;
        long ramMax = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
        double cpuLoad = Helpers.getProcessCpuLoad() * 100.0;
        double tps = Helpers.getTPS();
        double mspt = tps > 0.0 ? 1000.0 / tps : 50.0;
        long uptimeMs = ManagementFactory.getRuntimeMXBean().getUptime();
        String uptime = String.valueOf(TimeUnit.MILLISECONDS.toSeconds(uptimeMs));
        String serverVersion = Bukkit.getVersion();
        List worlds = Bukkit.getWorlds();
        String worldName = worlds.isEmpty() ? "Unknown" : ((World)worlds.get(0)).getName();
        String defaultGameMode = "Unknown";
        try {
            defaultGameMode = Bukkit.getDefaultGameMode().name();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String difficulty = "Unknown";
        try {
            difficulty = worlds.isEmpty() ? "Unknown" : ((World)worlds.get(0)).getDifficulty().name();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Main.backupManager.updateTotalBackups();
        int backups = Main.backupManager.totalBackups;
        String json = "{\"players\":" + players + ",\"max_players\":" + maxPlayers + ",\"tps\":" + String.format("%.2f", tps) + ",\"mspt\":" + String.format("%.2f", mspt) + ",\"ram_used_mb\":" + ramUsed + ",\"ram_max_mb\":" + ramMax + ",\"cpu_percent\":" + String.format("%.2f", cpuLoad) + ",\"uptime\":\"" + Helpers.escapeJson(uptime) + "\",\"server_version\":\"" + Helpers.escapeJson(serverVersion) + "\",\"world_name\":\"" + Helpers.escapeJson(worldName) + "\",\"default_game_mode\":\"" + Helpers.escapeJson(defaultGameMode) + "\",\"difficulty\":\"" + Helpers.escapeJson(difficulty) + "\",\"backups\":" + backups + "}";
        return json;
    }

    private static void sendTextResponse(HttpExchange exchange, int statusCode, String text) throws IOException {
        byte[] bytes = text.getBytes(StandardCharsets.UTF_8);
        WebServer.sendBytes(exchange, statusCode, bytes);
    }

    private static void sendBytes(HttpExchange exchange, int statusCode, byte[] data) throws IOException {
        exchange.sendResponseHeaders(statusCode, data.length);
        try (OutputStream os = exchange.getResponseBody();){
            os.write(data);
        }
    }

    public static void stop() {
        if (server != null) {
            server.stop(0);
            server = null;
            running.set(false);
            Log.info("WebServer stopped.");
        } else {
            Log.warn("WebServer is not running.");
        }
    }

    public static boolean verify(String code) {
        return false;
    }

    static {
        running = new AtomicBoolean(false);
    }
}

