/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsutils.commands;

import dev.xdpxi.xdsutils.Main;
import dev.xdpxi.xdsutils.WebServer;
import dev.xdpxi.xdsutils.utils.Config;
import dev.xdpxi.xdsutils.utils.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public record XDsUtils(Main plugin) implements CommandExecutor,
TabCompleter
{
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 0) {
            return false;
        }
        return switch (args[0].toLowerCase()) {
            case "reload" -> this.reloadConfig(sender);
            case "backup" -> {
                if (args.length > 1) {
                    switch (args[1].toLowerCase()) {
                        case "status": {
                            yield this.backupStatus(sender);
                        }
                    }
                    yield this.backupServer(sender);
                }
                yield this.backupServer(sender);
            }
            case "web" -> this.webVerify(sender, args);
            case "disabledItems" -> {
                if (args.length == 1) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /xdsutils disabledItems <get|add|remove> [item]");
                    yield true;
                }
                switch (args[1].toLowerCase()) {
                    case "get": {
                        yield this.getDisabledItems(sender);
                    }
                    case "add": {
                        if (args.length < 3) {
                            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /xdsutils disabledItems add <item>");
                            yield true;
                        }
                        yield this.addDisabledItems(sender, args[2]);
                    }
                    case "remove": {
                        if (args.length < 3) {
                            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /xdsutils disabledItems remove <item>");
                            yield true;
                        }
                        yield this.removeDisabledItems(sender, args[2]);
                    }
                }
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown subcommand: " + args[1]);
                yield true;
            }
            default -> false;
        };
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            if (sender.hasPermission("xdsutils.reload") || sender.isOp()) {
                completions.add("reload");
            }
            if (sender.hasPermission("xdsutils.backup") || sender.isOp()) {
                completions.add("backup");
            }
            if (sender.hasPermission("xdsutils.web") || sender.isOp()) {
                completions.add("web");
            }
            if (sender.hasPermission("xdsutils.disabledItems") || sender.isOp()) {
                completions.add("disabledItems");
            }
            return completions;
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("backup") && (sender.hasPermission("xdsutils.backup") || sender.isOp())) {
                completions.add("status");
            } else if (args[0].equalsIgnoreCase("web") && (sender.hasPermission("xdsutils.web") || sender.isOp())) {
                completions.add("<code>");
            } else if (args[0].equalsIgnoreCase("disabledItems") && (sender.hasPermission("xdsutils.disabledItems") || sender.isOp())) {
                completions.add("get");
                completions.add("add");
                completions.add("remove");
            }
            return completions;
        }
        if (args.length == 3) {
            if (args[0].equalsIgnoreCase("disabledItems") && args[1].equalsIgnoreCase("add") && (sender.hasPermission("xdsutils.disabledItems") || sender.isOp())) {
                for (Material material : Material.values()) {
                    if (!material.isItem()) continue;
                    completions.add("minecraft:" + material.name().toLowerCase());
                }
            }
            if (args[0].equalsIgnoreCase("disabledItems") && args[1].equalsIgnoreCase("remove") && (sender.hasPermission("xdsutils.disabledItems") || sender.isOp())) {
                for (Material material : Material.values()) {
                    if (!material.isItem()) continue;
                    completions.add("minecraft:" + material.name().toLowerCase());
                }
            }
            return completions;
        }
        return completions;
    }

    private boolean hasPermission(CommandSender sender, String permission) {
        if (sender.hasPermission(permission) || sender.isOp()) {
            return false;
        }
        sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to perform this action!");
        return true;
    }

    private boolean reloadConfig(CommandSender sender) {
        if (this.hasPermission(sender, "xdsutils.reload")) {
            return true;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, Config::reload);
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Configuration reloaded successfully!");
        return true;
    }

    private boolean backupServer(CommandSender sender) {
        if (this.hasPermission(sender, "xdsutils.backup")) {
            return true;
        }
        if (Main.backupManager.isRunning.get()) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "A backup is already running. Please wait until it finishes.");
            return true;
        }
        Main.backupManager.runBackupNow();
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Backup started successfully!");
        return true;
    }

    private boolean backupStatus(CommandSender sender) {
        if (this.hasPermission(sender, "xdsutils.backup")) {
            return true;
        }
        if (Main.backupManager.isRunning.get()) {
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "A backup is currently running.");
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "No backup is currently running.");
        return true;
    }

    private boolean webVerify(CommandSender sender, String[] args) {
        if (this.hasPermission(sender, "xdsutils.web")) {
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "/xdsutils web <code>");
            return true;
        }
        if (!WebServer.verify(args[1])) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid verification code.");
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Verification successful!");
        return true;
    }

    private boolean getDisabledItems(CommandSender sender) {
        if (Main.disabledItems.isEmpty()) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "No disabled items.");
            Log.info("No disabled items found when queried by " + sender.getName());
        } else {
            String itemsList = Main.disabledItems.stream().map(String::toLowerCase).collect(Collectors.joining(", "));
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Disabled items: " + itemsList);
            Log.info(sender.getName() + " queried disabled items: " + itemsList);
        }
        return true;
    }

    private boolean addDisabledItems(CommandSender sender, String itemId) {
        String normalized = itemId.toUpperCase();
        if (Main.disabledItems.contains(normalized)) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + normalized + " is already disabled.");
            Log.warn(sender.getName() + " tried to add already disabled item: " + normalized);
        } else {
            try {
                Main.disabledItems.add(normalized);
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Disabled item: " + normalized);
                Log.info(sender.getName() + " disabled item: " + normalized);
            }
            catch (Exception e) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to disable item: " + normalized);
                Log.error("Error disabling item " + normalized + " by " + sender.getName() + String.valueOf(e));
            }
        }
        return true;
    }

    private boolean removeDisabledItems(CommandSender sender, String itemId) {
        String normalized = itemId.toUpperCase();
        if (!Main.disabledItems.contains(normalized)) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + normalized + " is not in the disabled items list.");
            Log.warn(sender.getName() + " tried to remove non-disabled item: " + normalized);
        } else {
            try {
                Main.disabledItems.remove(normalized);
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Removed disabled item: " + normalized);
                Log.info(sender.getName() + " removed disabled item: " + normalized);
            }
            catch (Exception e) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to remove disabled item: " + normalized);
                Log.error("Error removing item " + normalized + " by " + sender.getName() + String.valueOf(e));
            }
        }
        return true;
    }
}

