/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsutils.utils;

import com.sun.management.OperatingSystemMXBean;
import dev.xdpxi.xdsutils.Main;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.Server;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Helpers {
    public static double getProcessCpuLoad() {
        try {
            OperatingSystemMXBean osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            double load = osBean.getProcessCpuLoad();
            if (Double.isNaN(load) || load < 0.0) {
                return 0.0;
            }
            return load;
        }
        catch (Throwable t) {
            return 0.0;
        }
    }

    public static double getTPS() {
        try {
            Object[] arr;
            Server server = Bukkit.getServer();
            Method m = server.getClass().getMethod("getTPS", new Class[0]);
            Object tpsObj = m.invoke((Object)server, new Object[0]);
            if (tpsObj instanceof double[]) {
                double[] arr2 = (double[])tpsObj;
                if (arr2.length > 0) {
                    return arr2[0];
                }
            } else if (tpsObj instanceof Object[] && (arr = (Object[])tpsObj).length > 0 && arr[0] instanceof Number) {
                return ((Number)arr[0]).doubleValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 20.0;
    }

    public static String escapeJson(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r");
    }

    public static boolean isItemDisabled(ItemStack item) {
        if (item == null) {
            return false;
        }
        NamespacedKey key = item.getType().getKey();
        if (Main.disabledItems.contains(key.toString().toLowerCase())) {
            return true;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta != null && meta.hasDisplayName()) {
            String displayName = meta.getDisplayName().toLowerCase();
            return Main.disabledItems.contains(displayName);
        }
        return false;
    }
}

